/*
 * Decompiled with CFR 0.152.
 */
package com.wso2.jwt.token.builder;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.authz.OAuthAuthzReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.OauthTokenIssuerImpl;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;

public class JWTAccessTokenBuilder
extends OauthTokenIssuerImpl {
    private static final String NONE = "NONE";
    private static final String SHA256_WITH_RSA = "SHA256withRSA";
    private static final String SHA384_WITH_RSA = "SHA384withRSA";
    private static final String SHA512_WITH_RSA = "SHA512withRSA";
    private static final String SHA256_WITH_HMAC = "SHA256withHMAC";
    private static final String SHA384_WITH_HMAC = "SHA384withHMAC";
    private static final String SHA512_WITH_HMAC = "SHA512withHMAC";
    private static final String SHA256_WITH_EC = "SHA256withEC";
    private static final String SHA384_WITH_EC = "SHA384withEC";
    private static final String SHA512_WITH_EC = "SHA512withEC";
    private static final Log log = LogFactory.getLog(JWTAccessTokenBuilder.class);
    private static Map<Integer, Key> privateKeys = new ConcurrentHashMap<Integer, Key>();
    private OAuthServerConfiguration config = null;
    private Algorithm signatureAlgorithm = null;

    public JWTAccessTokenBuilder() throws IdentityOAuth2Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"JWT Access token builder is initiated");
        }
        this.config = OAuthServerConfiguration.getInstance();
        this.signatureAlgorithm = this.mapSignatureAlgorithm(this.config.getSignatureAlgorithm());
    }

    public String accessToken(OAuthTokenReqMessageContext oAuthTokenReqMessageContext) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token request with token request message context. Authorized user " + oAuthTokenReqMessageContext.getAuthorizedUser().toString()));
        }
        try {
            return this.buildIDToken(oAuthTokenReqMessageContext);
        }
        catch (IdentityOAuth2Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while issuing jwt access token. Hence returning default token", (Throwable)e);
            }
            return super.accessToken(oAuthTokenReqMessageContext);
        }
    }

    public String accessToken(OAuthAuthzReqMessageContext oAuthAuthzReqMessageContext) throws OAuthSystemException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Access token request with authorization request message context message context. Authorized user " + oAuthAuthzReqMessageContext.getAuthorizationReqDTO().getUser().toString()));
        }
        try {
            return this.buildIDToken(oAuthAuthzReqMessageContext);
        }
        catch (IdentityOAuth2Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error occurred while issuing jwt access token. Hence returning default token", (Throwable)e);
            }
            return super.accessToken(oAuthAuthzReqMessageContext);
        }
    }

    protected String buildIDToken(OAuthTokenReqMessageContext request) throws IdentityOAuth2Exception {
        String issuer = OAuth2Util.getIDTokenIssuer();
        long lifetimeInMillis = OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() * 1000L;
        long curTimeInMillis = Calendar.getInstance().getTimeInMillis();
        String subject = request.getAuthorizedUser().getAuthenticatedSubjectIdentifier();
        if (!StringUtils.isNotBlank((String)subject)) {
            subject = request.getAuthorizedUser().getUserName();
        }
        JWTClaimsSet jwtClaimsSet = new JWTClaimsSet();
        jwtClaimsSet.setIssuer(issuer);
        jwtClaimsSet.setSubject(subject);
        jwtClaimsSet.setAudience(Arrays.asList(request.getOauth2AccessTokenReqDTO().getClientId()));
        jwtClaimsSet.setClaim("azp", (Object)request.getOauth2AccessTokenReqDTO().getClientId());
        jwtClaimsSet.setExpirationTime(new Date(curTimeInMillis + lifetimeInMillis));
        jwtClaimsSet.setIssueTime(new Date(curTimeInMillis));
        this.addUserClaims(jwtClaimsSet, request.getAuthorizedUser());
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, request);
    }

    protected String buildIDToken(OAuthAuthzReqMessageContext request) throws IdentityOAuth2Exception {
        String issuer = OAuth2Util.getIDTokenIssuer();
        long lifetimeInMillis = OAuthServerConfiguration.getInstance().getApplicationAccessTokenValidityPeriodInSeconds() * 1000L;
        long curTimeInMillis = Calendar.getInstance().getTimeInMillis();
        String subject = request.getAuthorizationReqDTO().getUser().getAuthenticatedSubjectIdentifier();
        if (!StringUtils.isNotBlank((String)subject)) {
            subject = request.getAuthorizationReqDTO().getUser().getUserName();
        }
        JWTClaimsSet jwtClaimsSet = new JWTClaimsSet();
        jwtClaimsSet.setIssuer(issuer);
        jwtClaimsSet.setSubject(subject);
        jwtClaimsSet.setAudience(Arrays.asList(request.getAuthorizationReqDTO().getConsumerKey()));
        jwtClaimsSet.setClaim("azp", (Object)request.getAuthorizationReqDTO().getConsumerKey());
        jwtClaimsSet.setExpirationTime(new Date(curTimeInMillis + lifetimeInMillis));
        jwtClaimsSet.setIssueTime(new Date(curTimeInMillis));
        this.addUserClaims(jwtClaimsSet, request.getAuthorizationReqDTO().getUser());
        if (JWSAlgorithm.NONE.getName().equals(this.signatureAlgorithm.getName())) {
            return new PlainJWT(jwtClaimsSet).serialize();
        }
        return this.signJWT(jwtClaimsSet, request);
    }

    protected String signJWTWithRSA(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext request) throws IdentityOAuth2Exception {
        try {
            Key privateKey;
            String tenantDomain = request.getAuthorizedUser().getTenantDomain();
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            if (!privateKeys.containsKey(tenantId)) {
                KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
                if (!tenantDomain.equals("carbon.super")) {
                    String ksName = tenantDomain.trim().replace(".", "-");
                    String jksName = ksName + ".jks";
                    privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
                } else {
                    try {
                        privateKey = tenantKSM.getDefaultPrivateKey();
                    }
                    catch (Exception e) {
                        throw new IdentityOAuth2Exception("Error while obtaining private key for super tenant", (Throwable)e);
                    }
                }
                privateKeys.put(tenantId, privateKey);
            } else {
                privateKey = privateKeys.get(tenantId);
            }
            RSASSASigner signer = new RSASSASigner((RSAPrivateKey)privateKey);
            SignedJWT signedJWT = null;
            if (this.signatureAlgorithm instanceof JWSAlgorithm) {
                signedJWT = new SignedJWT(new JWSHeader((JWSAlgorithm)this.signatureAlgorithm), (ReadOnlyJWTClaimsSet)jwtClaimsSet);
                signedJWT.sign((JWSSigner)signer);
                return signedJWT.serialize();
            }
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Error occurred while signing JWT", (Throwable)e);
        }
        return null;
    }

    protected String signJWTWithRSA(JWTClaimsSet jwtClaimsSet, OAuthAuthzReqMessageContext request) throws IdentityOAuth2Exception {
        try {
            Key privateKey;
            String tenantDomain = "carbon.super";
            int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
            if (!privateKeys.containsKey(tenantId)) {
                KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
                if (!tenantDomain.equals("carbon.super")) {
                    String ksName = tenantDomain.trim().replace(".", "-");
                    String jksName = ksName + ".jks";
                    privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
                } else {
                    try {
                        privateKey = tenantKSM.getDefaultPrivateKey();
                    }
                    catch (Exception e) {
                        throw new IdentityOAuth2Exception("Error while obtaining private key for super tenant", (Throwable)e);
                    }
                }
                privateKeys.put(tenantId, privateKey);
            } else {
                privateKey = privateKeys.get(tenantId);
            }
            RSASSASigner signer = new RSASSASigner((RSAPrivateKey)privateKey);
            SignedJWT signedJWT = null;
            if (this.signatureAlgorithm instanceof JWSAlgorithm) {
                signedJWT = new SignedJWT(new JWSHeader((JWSAlgorithm)this.signatureAlgorithm), (ReadOnlyJWTClaimsSet)jwtClaimsSet);
                signedJWT.sign((JWSSigner)signer);
                return signedJWT.serialize();
            }
        }
        catch (JOSEException e) {
            throw new IdentityOAuth2Exception("Error occurred while signing JWT", (Throwable)e);
        }
        return null;
    }

    protected String signJWT(JWTClaimsSet jwtClaimsSet, OAuthTokenReqMessageContext request) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithRSA(jwtClaimsSet, request);
        }
        if (JWSAlgorithm.HS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)this.signatureAlgorithm)) {
            return null;
        }
        return null;
    }

    protected String signJWT(JWTClaimsSet jwtClaimsSet, OAuthAuthzReqMessageContext request) throws IdentityOAuth2Exception {
        if (JWSAlgorithm.RS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.RS512.equals((Object)this.signatureAlgorithm)) {
            return this.signJWTWithRSA(jwtClaimsSet, request);
        }
        if (JWSAlgorithm.HS256.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS384.equals((Object)this.signatureAlgorithm) || JWSAlgorithm.HS512.equals((Object)this.signatureAlgorithm)) {
            return null;
        }
        return null;
    }

    protected JWSAlgorithm mapSignatureAlgorithm(String signatureAlgorithm) throws IdentityOAuth2Exception {
        if (NONE.equals(signatureAlgorithm)) {
            return new JWSAlgorithm(JWSAlgorithm.NONE.getName());
        }
        if (SHA256_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS256;
        }
        if (SHA384_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS384;
        }
        if (SHA512_WITH_RSA.equals(signatureAlgorithm)) {
            return JWSAlgorithm.RS512;
        }
        if (SHA256_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS256;
        }
        if (SHA384_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS384;
        }
        if (SHA512_WITH_HMAC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.HS512;
        }
        if (SHA256_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES256;
        }
        if (SHA384_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES384;
        }
        if (SHA512_WITH_EC.equals(signatureAlgorithm)) {
            return JWSAlgorithm.ES512;
        }
        throw new IdentityOAuth2Exception("Unsupported Signature Algorithm in identity.xml");
    }

    private void addUserClaims(JWTClaimsSet jwtClaimsSet, AuthenticatedUser user) {
        for (Map.Entry entry : user.getUserAttributes().entrySet()) {
            ClaimMapping claimMapping = (ClaimMapping)entry.getKey();
            Claim claim = claimMapping.getLocalClaim();
            if (claim == null || !"customer_id".equalsIgnoreCase(claim.getClaimUri())) continue;
            jwtClaimsSet.setClaim("customer_id", entry.getValue());
        }
    }
}

