/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel.pool;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PoolConfiguration.class);
    private static PoolConfiguration poolConfiguration;
    private int maxActivePerPool = -1;
    private int minIdlePerPool;
    private int maxIdlePerPool = 100;
    private boolean testOnBorrow = true;
    private boolean testWhileIdle = true;
    private long timeBetweenEvictionRuns = 30000L;
    private long minEvictableIdleTime = 300000L;
    private byte exhaustedAction = (byte)2;
    private int numberOfPools = 0;
    private int executorServiceThreads = 20;

    private PoolConfiguration(Map<String, String> parameters) {
        if (parameters != null) {
            this.numberOfPools = parameters.get("connection.pool.count") != null ? Integer.parseInt(parameters.get("connection.pool.count")) : 0;
            this.maxActivePerPool = parameters.get("max.active.connections.per.pool") != null ? Integer.parseInt(parameters.get("max.active.connections.per.pool")) : -1;
            this.minIdlePerPool = parameters.get("min.idle.connections.per.pool") != null ? Integer.parseInt(parameters.get("min.idle.connections.per.pool")) : 0;
            this.maxIdlePerPool = parameters.get("max.idle.connections.per.pool") != null ? Integer.parseInt(parameters.get("max.idle.connections.per.pool")) : 100;
            this.minEvictableIdleTime = parameters.get("min.eviction.idle.time") != null ? (long)Integer.parseInt(parameters.get("min.eviction.idle.time")) : 300000L;
            this.executorServiceThreads = parameters.get("sender.thread.count") != null ? Integer.parseInt(parameters.get("sender.thread.count")) : 20;
        }
        logger.debug("connection.pool.count: " + this.numberOfPools);
        logger.debug("max.active.connections.per.pool:" + this.maxActivePerPool);
        logger.debug("min.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("max.idle.connections.per.pool:" + this.maxIdlePerPool);
        logger.debug("min.eviction.idle.time:" + this.minEvictableIdleTime);
        logger.debug("sender.thread.count:" + this.executorServiceThreads);
        logger.debug("Time between Evictions Runs:" + this.timeBetweenEvictionRuns);
        logger.debug("Pool exhausted action:" + this.exhaustedAction);
    }

    public static PoolConfiguration getInstance() {
        return poolConfiguration;
    }

    public static void createPoolConfiguration(Map<String, String> parameters) {
        poolConfiguration = new PoolConfiguration(parameters);
    }

    public int getMaxActivePerPool() {
        return this.maxActivePerPool;
    }

    public int getMinIdlePerPool() {
        return this.minIdlePerPool;
    }

    public int getMaxIdlePerPool() {
        return this.maxIdlePerPool;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public long getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public long getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public byte getExhaustedAction() {
        return this.exhaustedAction;
    }

    public int getNumberOfPools() {
        return this.numberOfPools;
    }

    public int getExecutorServiceThreads() {
        return this.executorServiceThreads;
    }
}

