/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.PlainHeader;
import com.nimbusds.jose.ReadOnlyHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Header
implements ReadOnlyHeader {
    protected final Algorithm alg;
    private JOSEObjectType typ;
    private String cty;
    private Set<String> crit;
    private Map<String, Object> customParameters = new HashMap<String, Object>();
    private Base64URL parsedBase64URL;

    protected Header(Algorithm alg) {
        if (alg == null) {
            throw new IllegalArgumentException("The algorithm \"alg\" header parameter must not be null");
        }
        this.alg = alg;
    }

    @Override
    public JOSEObjectType getType() {
        return this.typ;
    }

    public void setType(JOSEObjectType typ) {
        this.typ = typ;
    }

    @Override
    public String getContentType() {
        return this.cty;
    }

    public void setContentType(String cty) {
        this.cty = cty;
    }

    @Override
    public Set<String> getCriticalHeaders() {
        return this.crit;
    }

    public void setCriticalHeaders(Set<String> crit) {
        this.crit = crit;
    }

    @Override
    public Object getCustomParameter(String name) {
        return this.customParameters.get(name);
    }

    protected void setCustomParameter(String name, Object value) {
        this.customParameters.put(name, value);
    }

    @Override
    public Map<String, Object> getCustomParameters() {
        return Collections.unmodifiableMap(this.customParameters);
    }

    public void setCustomParameters(Map<String, Object> customParameters) {
        if (customParameters == null) {
            return;
        }
        this.customParameters = customParameters;
    }

    protected void setParsedBase64URL(Base64URL parsedBase64URL) {
        this.parsedBase64URL = parsedBase64URL;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject(this.customParameters);
        o.put("alg", this.alg.toString());
        if (this.typ != null) {
            o.put("typ", this.typ.toString());
        }
        if (this.cty != null) {
            o.put("cty", this.cty);
        }
        if (this.crit != null && !this.crit.isEmpty()) {
            o.put("crit", new ArrayList<String>(this.crit));
        }
        return o;
    }

    @Override
    public String toString() {
        return this.toJSONObject().toString();
    }

    @Override
    public Base64URL toBase64URL() {
        if (this.parsedBase64URL == null) {
            return Base64URL.encode(this.toString());
        }
        return this.parsedBase64URL;
    }

    public static Algorithm parseAlgorithm(JSONObject json) throws ParseException {
        String algName = JSONObjectUtils.getString(json, "alg");
        if (algName.equals(Algorithm.NONE.getName())) {
            return Algorithm.NONE;
        }
        if (json.containsKey("enc")) {
            return JWEAlgorithm.parse(algName);
        }
        return JWSAlgorithm.parse(algName);
    }

    public static Header parse(JSONObject json) throws ParseException {
        Algorithm alg = Header.parseAlgorithm(json);
        if (alg.equals(Algorithm.NONE)) {
            return PlainHeader.parse(json);
        }
        if (alg instanceof JWSAlgorithm) {
            return JWSHeader.parse(json);
        }
        if (alg instanceof JWEAlgorithm) {
            return JWEHeader.parse(json);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + alg));
    }

    public static Header parse(String s) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parseJSONObject(s);
        return Header.parse(jsonObject);
    }

    public static Header parse(Base64URL base64URL) throws ParseException {
        Header header = Header.parse(base64URL.decodeToString());
        header.setParsedBase64URL(base64URL);
        return header;
    }
}

