/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.common.tracing;

import java.io.IOException;
import java.util.Date;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.wso2.msf4j.analytics.common.tracing.TraceEvent;
import org.wso2.msf4j.analytics.common.tracing.TracingEventTracker;
import org.wso2.msf4j.analytics.common.tracing.TracingUtil;

public class MSF4JClientTracingFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String TRACE_EVENT_ATTRIBUTE = "trace-event-attribute";
    private TraceEvent parentEvent;
    private String instanceId;
    private String instanceName;
    private String dasUrl;

    public MSF4JClientTracingFilter(String clientName) {
        this(clientName, "http://localhost:9763/endpoints/msf4jtracereceiver");
    }

    public MSF4JClientTracingFilter(String clientName, String dasUrl) {
        this(clientName, null, dasUrl);
    }

    public MSF4JClientTracingFilter(String clientName, TraceEvent parentEvent, String dasUrl) {
        this.instanceName = clientName;
        this.instanceId = TracingUtil.generateUniqueId();
        this.dasUrl = dasUrl;
        this.parentEvent = parentEvent != null ? parentEvent : TracingEventTracker.getTraceEvent();
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        String clientTraceId;
        String traceOriginId;
        long time = new Date().getTime();
        String traceParentId = null;
        if (this.parentEvent == null) {
            clientTraceId = traceOriginId = TracingUtil.generateUniqueId();
        } else {
            traceOriginId = this.parentEvent.getOriginId();
            clientTraceId = TracingUtil.generateUniqueId();
            traceParentId = this.parentEvent.getTraceId();
        }
        TraceEvent clientTraceEvent = new TraceEvent("CTS", clientTraceId, traceOriginId, time);
        clientTraceEvent.setInstanceId(this.instanceId);
        clientTraceEvent.setInstanceName(this.instanceName);
        clientTraceEvent.setParentId(traceParentId);
        clientTraceEvent.setHttpMethod(requestContext.getMethod());
        clientTraceEvent.setUrl(requestContext.getUri().toString());
        requestContext.setProperty(TRACE_EVENT_ATTRIBUTE, (Object)clientTraceEvent);
        requestContext.getHeaders().putSingle((Object)"X-msf4j-trace-id", (Object)clientTraceId);
        requestContext.getHeaders().putSingle((Object)"X-msf4j-trace-origin-id", (Object)traceOriginId);
        TracingUtil.pushToDAS(clientTraceEvent, this.dasUrl);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        long time = new Date().getTime();
        TraceEvent traceEvent = (TraceEvent)requestContext.getProperty(TRACE_EVENT_ATTRIBUTE);
        if (traceEvent != null) {
            TraceEvent endTraceEvent = new TraceEvent("CTE", traceEvent.getTraceId(), traceEvent.getOriginId(), time);
            endTraceEvent.setStatusCode(responseContext.getStatus());
            TracingUtil.pushToDAS(endTraceEvent, this.dasUrl);
        }
    }
}

