/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.client;

import feign.Client;
import feign.Feign;
import feign.RequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import feign.hystrix.FallbackFactory;
import feign.hystrix.HystrixFeign;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.utils.StringUtils;
import org.wso2.msf4j.client.ApacheHttpClient;
import org.wso2.msf4j.client.FeignClientWrapper;
import org.wso2.msf4j.client.FeignTracingClient;
import org.wso2.msf4j.client.ModelUtils;
import org.wso2.msf4j.client.codec.DefaultErrorDecoder;
import org.wso2.msf4j.client.codec.RestErrorResponseMapper;
import org.wso2.msf4j.client.exception.RestServiceException;

public class MSF4JClient<T> {
    private static final Logger log = LoggerFactory.getLogger(MSF4JClient.class);
    private final T api;

    public MSF4JClient(T api) {
        this.api = api;
    }

    public T api() {
        return this.api;
    }

    public static class Builder<T> {
        private final List<RequestInterceptor> requestInterceptors = new ArrayList<RequestInterceptor>();
        private final Map<String, Class<? extends RestServiceException>> errorCodeExceptionMap = new HashMap<String, Class<? extends RestServiceException>>();
        private FallbackFactory<? extends T> fallbackFactory;
        private boolean enableCircuitBreaker;
        private boolean enableTracing;
        private String instanceName;
        private String analyticsEndpoint;
        private String serviceEndpoint;
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private boolean decode404;
        private Class<T> apiClass;
        private ErrorDecoder errorDecoder = new DefaultErrorDecoder(this.errorCodeExceptionMap);

        public Feign.Builder newFeignClientBuilder() {
            return Feign.builder().encoder((Encoder)new GsonEncoder(ModelUtils.GSON)).decoder((Decoder)new GsonDecoder(ModelUtils.GSON));
        }

        public HystrixFeign.Builder newHystrixFeignClientBuilder() {
            return HystrixFeign.builder().encoder((Encoder)new GsonEncoder(ModelUtils.GSON)).decoder((Decoder)new GsonDecoder(ModelUtils.GSON));
        }

        public Builder<T> requestInterceptor(RequestInterceptor requestInterceptor) {
            this.requestInterceptors.add(requestInterceptor);
            return this;
        }

        public Builder<T> requestInterceptors(Iterable<RequestInterceptor> requestInterceptors) {
            this.requestInterceptors.clear();
            for (RequestInterceptor requestInterceptor : requestInterceptors) {
                this.requestInterceptors.add(requestInterceptor);
            }
            return this;
        }

        public Builder<T> fallbackFactory(FallbackFactory<? extends T> fallbackFactory) {
            this.fallbackFactory = fallbackFactory;
            return this;
        }

        public Builder<T> enableCircuitBreaker() {
            this.enableCircuitBreaker = true;
            return this;
        }

        public Builder<T> enableTracing() {
            this.enableTracing = true;
            return this;
        }

        public Builder<T> instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder<T> analyticsEndpoint(String analyticsEndpoint) {
            this.analyticsEndpoint = analyticsEndpoint;
            return this;
        }

        public Builder<T> serviceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder<T> apiClass(Class<T> apiClass) {
            this.apiClass = apiClass;
            return this;
        }

        public Builder<T> decode404(boolean decode404) {
            this.decode404 = decode404;
            return this;
        }

        public Builder<T> addErrorResponseMapper(RestErrorResponseMapper ... responseMappers) {
            Arrays.stream(responseMappers).forEach(rm -> Arrays.stream(rm.getClass().getMethods()).filter(method -> !StringUtils.isNullOrEmptyAfterTrim((String)rm.getExceptionKey())).findAny().ifPresent(method -> {
                if (this.errorCodeExceptionMap.containsKey(rm.getExceptionKey())) {
                    log.warn("RestErrorResponseMapper has already been added for the given exception key '{}'", (Object)rm.getExceptionKey());
                }
                this.errorCodeExceptionMap.put(rm.getExceptionKey(), rm.getExceptionClass());
            }));
            return this;
        }

        public Builder<T> errorDecoder(ErrorDecoder errorDecoder) {
            this.errorDecoder = errorDecoder;
            return this;
        }

        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public void setSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        public MSF4JClient<T> build() {
            MSF4JClient<Object> msf4JClient;
            CloseableHttpClient apacheHttpClient = HttpClientBuilder.create().setSSLContext(this.sslContext).setSSLHostnameVerifier(this.hostnameVerifier).build();
            FeignClientWrapper client = this.enableTracing ? new FeignClientWrapper(new FeignTracingClient(new ApacheHttpClient((HttpClient)apacheHttpClient), this.instanceName, this.analyticsEndpoint)) : new FeignClientWrapper(new ApacheHttpClient((HttpClient)apacheHttpClient));
            if (this.enableCircuitBreaker) {
                HystrixFeign.Builder builder = this.newHystrixFeignClientBuilder();
                builder.client((Client)client);
                builder.requestInterceptors(this.requestInterceptors);
                builder.errorDecoder(this.errorDecoder);
                if (this.decode404) {
                    builder.decode404();
                }
                msf4JClient = new MSF4JClient<Object>(builder.target(this.apiClass, this.serviceEndpoint, this.fallbackFactory));
            } else {
                Feign.Builder builder = this.newFeignClientBuilder();
                builder.client((Client)client);
                builder.requestInterceptors(this.requestInterceptors);
                builder.errorDecoder(this.errorDecoder);
                if (this.decode404) {
                    builder.decode404();
                }
                msf4JClient = new MSF4JClient<Object>(builder.target(this.apiClass, this.serviceEndpoint));
            }
            return msf4JClient;
        }
    }
}

