/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.beanconversion;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.wso2.msf4j.beanconversion.BeanConversionException;
import org.wso2.msf4j.beanconversion.MediaTypeConverter;

public class XmlConverter
extends MediaTypeConverter {
    private static final String TEXT_XML = "text/xml";

    public String[] getSupportedMediaTypes() {
        return new String[]{"application/xml", TEXT_XML};
    }

    public ByteBuffer toMedia(Object object) throws BeanConversionException {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(object, (Writer)stringWriter);
            return ByteBuffer.wrap(stringWriter.toString().getBytes(Charset.defaultCharset()));
        }
        catch (JAXBException e) {
            throw new BeanConversionException("Unable to perform object to xml conversion", (Exception)((Object)e));
        }
    }

    public Object toObject(ByteBuffer content, Type targetType) throws BeanConversionException {
        try {
            String str = Charset.defaultCharset().decode(content).toString();
            JAXBContext jaxbContext = null;
            if (targetType instanceof Class) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{(Class)targetType});
                return jaxbContext.createUnmarshaller().unmarshal((Reader)new StringReader(str));
            }
        }
        catch (JAXBException e) {
            throw new BeanConversionException("Unable to perform xml to object conversion", (Exception)((Object)e));
        }
        return null;
    }
}

