/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.entitywriter;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.io.FilenameUtils;
import org.wso2.msf4j.internal.entitywriter.EntityWriter;
import org.wso2.msf4j.internal.mime.MimeMapper;
import org.wso2.msf4j.internal.mime.MimeMappingException;
import org.wso2.transport.http.netty.contract.ServerConnectorException;
import org.wso2.transport.http.netty.message.HTTPCarbonMessage;

public class FileEntityWriter
implements EntityWriter<File> {
    public static final int DEFAULT_CHUNK_SIZE = 1024;

    @Override
    public Class<File> getType() {
        return File.class;
    }

    @Override
    public void writeData(HTTPCarbonMessage httpCarbonMessage, File file, String mediaType, int chunkSize, HTTPCarbonMessage responder) {
        if (mediaType == null || mediaType.equals("*/*")) {
            try {
                mediaType = MimeMapper.getMimeType(FilenameUtils.getExtension((String)file.getName()));
            }
            catch (MimeMappingException e) {
                mediaType = "*/*";
            }
        }
        try {
            FileChannel fileChannel = new FileInputStream(file).getChannel();
            if (chunkSize == 0 || chunkSize == -1) {
                chunkSize = 1024;
            }
            httpCarbonMessage.setHeader(HttpHeaderNames.TRANSFER_ENCODING.toString(), "chunked");
            httpCarbonMessage.setHeader(HttpHeaderNames.CONTENT_TYPE.toString(), mediaType);
            try {
                responder.respond(httpCarbonMessage);
            }
            catch (ServerConnectorException e) {
                throw new RuntimeException("Error while sending the response.", e);
            }
            ByteBuffer buffer = ByteBuffer.allocate(chunkSize);
            while (fileChannel.read(buffer) != -1) {
                buffer.flip();
                httpCarbonMessage.addHttpContent((HttpContent)new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuffer)buffer)));
                buffer = ByteBuffer.allocate(chunkSize);
            }
            fileChannel.close();
            httpCarbonMessage.addHttpContent((HttpContent)new DefaultLastHttpContent());
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while reading from file", e);
        }
    }
}

