/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.websocket;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.internal.router.PatternPathRouter;
import org.wso2.msf4j.internal.websocket.EndpointDispatcher;
import org.wso2.msf4j.internal.websocket.EndpointValidator;
import org.wso2.msf4j.websocket.WebSocketEndpointsRegistry;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointAnnotationException;
import org.wso2.msf4j.websocket.exception.WebSocketEndpointMethodReturnTypeException;
import org.wso2.msf4j.websocket.exception.WebSocketMethodParameterException;

public class EndpointsRegistryImpl
implements WebSocketEndpointsRegistry {
    private static final Logger log = LoggerFactory.getLogger(EndpointsRegistryImpl.class);
    private static final EndpointsRegistryImpl webSocketEndpointsRegistry = new EndpointsRegistryImpl();
    private final EndpointValidator validator = new EndpointValidator();
    private final Map<String, Object> webSocketEndpointMap = new ConcurrentHashMap<String, Object>();
    private PatternPathRouter<Object> endpointPatternPathRouter = PatternPathRouter.create();

    private EndpointsRegistryImpl() {
    }

    public static EndpointsRegistryImpl getInstance() {
        return webSocketEndpointsRegistry;
    }

    public List<Object> addEndpoint(Object ... webSocketEndpoints) {
        LinkedList<Object> endpointsWithError = new LinkedList<Object>();
        Arrays.stream(webSocketEndpoints).forEach(endpoint -> {
            EndpointDispatcher dispatcher = new EndpointDispatcher();
            try {
                if (this.validator.validate(endpoint)) {
                    this.webSocketEndpointMap.put(dispatcher.getUri(endpoint), endpoint);
                    log.info("Endpoint Registered : " + dispatcher.getUri(endpoint));
                }
            }
            catch (WebSocketEndpointAnnotationException e) {
                endpointsWithError.add(endpoint);
                log.error("Cannot deploy endpoint: server endpoint not defined." + System.lineSeparator() + e.toString());
            }
            catch (WebSocketMethodParameterException e) {
                endpointsWithError.add(endpoint);
                log.error("Cannot deploy endpoint " + endpoint.getClass().getName() + ": error method definition." + System.lineSeparator() + e.toString());
            }
            catch (WebSocketEndpointMethodReturnTypeException e) {
                endpointsWithError.add(endpoint);
                log.error("Cannot deploy endpoint " + endpoint.getClass().getName() + ": invalid method return type." + System.lineSeparator() + e.toString());
            }
        });
        this.updatePatternPathRouter();
        return endpointsWithError;
    }

    public void removeEndpoint(Object webSocketEndpoint) {
        EndpointDispatcher dispatcher = new EndpointDispatcher();
        this.webSocketEndpointMap.remove(dispatcher.getUri(webSocketEndpoint));
        this.updatePatternPathRouter();
        log.info("Removed endpoint : " + dispatcher.getUri(webSocketEndpoint));
    }

    public PatternPathRouter.RoutableDestination<Object> getRoutableEndpoint(String uri) {
        List<PatternPathRouter.RoutableDestination<Object>> routableDestinations = this.endpointPatternPathRouter.getDestinations(uri);
        return this.getBestEndpoint(routableDestinations, uri);
    }

    public Set<Object> getAllEndpoints() {
        return this.webSocketEndpointMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private PatternPathRouter.RoutableDestination<Object> getBestEndpoint(List<PatternPathRouter.RoutableDestination<Object>> routableDestinationList, String requestUri) {
        PatternPathRouter.RoutableDestination<Object> bestRoutableDestination = null;
        int currentBestHitCount = 0;
        for (PatternPathRouter.RoutableDestination<Object> currentRoutableDestination : routableDestinationList) {
            int tempCount = this.getHitCount(new EndpointDispatcher().getUri(currentRoutableDestination.getDestination()).split("/"), requestUri.split("/"));
            if (tempCount <= currentBestHitCount) continue;
            bestRoutableDestination = currentRoutableDestination;
            currentBestHitCount = tempCount;
        }
        return bestRoutableDestination;
    }

    private void updatePatternPathRouter() {
        this.endpointPatternPathRouter = PatternPathRouter.create();
        this.webSocketEndpointMap.entrySet().forEach(entry -> this.endpointPatternPathRouter.add((String)entry.getKey(), entry.getValue()));
    }

    private int getHitCount(String[] destinationUriChunkArray, String[] requestUriChunkArray) {
        int count = 0;
        for (int i = 0; i < destinationUriChunkArray.length; ++i) {
            if (!destinationUriChunkArray[i].equals(requestUriChunkArray[i])) continue;
            ++count;
        }
        return count;
    }
}

