/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring;

import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.io.ResourceLoader;
import org.wso2.msf4j.spring.MSF4JSpringConfiguration;

public class MSF4JSpringApplication {
    private static final String DEFAULT_CONTEXT_CLASS = "org.springframework.context.annotation.AnnotationConfigApplicationContext";
    private Class source;
    private Class<?> configurationClass;
    private Class<? extends ConfigurableApplicationContext> applicationContextClass;
    private ResourceLoader resourceLoader;
    private List<ApplicationContextInitializer<?>> initializers;

    public MSF4JSpringApplication(Class sources) {
        this.initialize(sources);
    }

    private void initialize(Class source) {
        if (source != null) {
            this.source = source;
        }
    }

    public static ConfigurableApplicationContext run(Class sources, String ... args) {
        return new MSF4JSpringApplication(sources).run(args);
    }

    public ConfigurableApplicationContext run(String ... args) {
        ConfigurableApplicationContext context = this.createApplicationContext();
        if (this.configurationClass != null) {
            this.registerIfAnnotationConfigApplicationContext(context);
        } else {
            this.scanIfAnnotationConfigApplicationContext(context);
        }
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        context.refresh();
        return context;
    }

    private void registerIfAnnotationConfigApplicationContext(ConfigurableApplicationContext context) {
        if (context instanceof AnnotationConfigApplicationContext) {
            ((AnnotationConfigApplicationContext)context).register(new Class[]{MSF4JSpringConfiguration.class, this.configurationClass});
        }
    }

    private void scanIfAnnotationConfigApplicationContext(ConfigurableApplicationContext context) {
        if (context instanceof AnnotationConfigApplicationContext) {
            String packagesForScan = this.getPackagesForScan();
            ((AnnotationConfigApplicationContext)context).register(new Class[]{MSF4JSpringConfiguration.class});
            ((AnnotationConfigApplicationContext)context).scan(new String[]{packagesForScan});
        }
    }

    private String getPackagesForScan() {
        return this.source.getPackage().getName();
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        Class<Object> contextClass = this.applicationContextClass;
        if (contextClass == null) {
            try {
                contextClass = Class.forName(DEFAULT_CONTEXT_CLASS);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable to create a default ApplicationContext, please specify an ApplicationContextClass", ex);
            }
        }
        return (ConfigurableApplicationContext)BeanUtils.instantiate(contextClass);
    }

    public Class<?> getConfigurationClass() {
        return this.configurationClass;
    }

    public void setConfigurationClass(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public Class<? extends ConfigurableApplicationContext> getApplicationContextClass() {
        return this.applicationContextClass;
    }

    public void setApplicationContextClass(Class<? extends ConfigurableApplicationContext> applicationContextClass) {
        this.applicationContextClass = applicationContextClass;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<ApplicationContextInitializer<?>> getInitializers() {
        return this.initializers;
    }

    public void setInitializers(List<ApplicationContextInitializer<?>> initializers) {
        this.initializers = initializers;
    }
}

