/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.spring;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.wso2.msf4j.spring.MSF4JSpringConfiguration;
import org.wso2.msf4j.spring.SpringMicroservicesRunner;
import org.wso2.msf4j.spring.property.YamlFileApplicationContextInitializer;

public class MSF4JSpringApplication {
    private static final String DEFAULT_CONTEXT_CLASS = "org.springframework.context.annotation.AnnotationConfigApplicationContext";
    private Class source;
    private Class<?> configurationClass;
    private Class<? extends ConfigurableApplicationContext> applicationContextClass;
    private ResourceLoader resourceLoader;
    private List<ApplicationContextInitializer<?>> initializers = new ArrayList();

    public MSF4JSpringApplication(Class sources) {
        this.initialize(sources);
    }

    private void initialize(Class source) {
        if (source != null) {
            this.source = source;
        }
        this.setInitializers(this.getSpringFactoriesInstances(ApplicationContextInitializer.class));
        this.addInitializers(new YamlFileApplicationContextInitializer());
    }

    public void setInitializers(Collection<? extends ApplicationContextInitializer<?>> initializers) {
        this.initializers = new ArrayList();
        this.initializers.addAll(initializers);
    }

    private <T> Collection<? extends T> getSpringFactoriesInstances(Class<T> type) {
        return this.getSpringFactoriesInstances(type, new Class[0], new Object[0]);
    }

    private <T> Collection<? extends T> getSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, Object ... args) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<String> names = new LinkedHashSet<String>(SpringFactoriesLoader.loadFactoryNames(type, (ClassLoader)classLoader));
        List<T> instances = this.createSpringFactoriesInstances(type, parameterTypes, classLoader, args, names);
        AnnotationAwareOrderComparator.sort(instances);
        return instances;
    }

    private <T> List<T> createSpringFactoriesInstances(Class<T> type, Class<?>[] parameterTypes, ClassLoader classLoader, Object[] args, Set<String> names) {
        ArrayList<Object> instances = new ArrayList<Object>(names.size());
        for (String name : names) {
            try {
                Class instanceClass = ClassUtils.forName((String)name, (ClassLoader)classLoader);
                Assert.isAssignable(type, (Class)instanceClass);
                Constructor constructor = instanceClass.getDeclaredConstructor(parameterTypes);
                Object instance = BeanUtils.instantiateClass(constructor, (Object[])args);
                instances.add(instance);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Cannot instantiate " + type + " : " + name, ex);
            }
        }
        return instances;
    }

    public void addInitializers(ApplicationContextInitializer<?> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public static ConfigurableApplicationContext run(Class sources, String ... args) {
        MSF4JSpringApplication application = new MSF4JSpringApplication(sources);
        ConfigurableApplicationContext context = application.run(false, args);
        application.applyInitializers(context);
        context.refresh();
        return context;
    }

    private void applyInitializers(ConfigurableApplicationContext context) {
        for (ApplicationContextInitializer<?> initializer : this.getInitializers()) {
            Class requiredType = GenericTypeResolver.resolveTypeArgument(initializer.getClass(), ApplicationContextInitializer.class);
            Assert.isInstanceOf((Class)requiredType, (Object)context, (String)"Unable to call initializer.");
            initializer.initialize(context);
        }
    }

    protected ConfigurableApplicationContext run(boolean doRefresh, String ... args) {
        ConfigurableApplicationContext context = this.createApplicationContext();
        if (this.configurationClass != null) {
            this.registerIfAnnotationConfigApplicationContext(context);
        } else {
            this.scanIfAnnotationConfigApplicationContext(context);
        }
        context.getEnvironment().getPropertySources().addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        if (doRefresh) {
            context.refresh();
        }
        return context;
    }

    private void registerIfAnnotationConfigApplicationContext(ConfigurableApplicationContext context) {
        if (context instanceof AnnotationConfigApplicationContext) {
            ((AnnotationConfigApplicationContext)context).register(new Class[]{MSF4JSpringConfiguration.class, this.configurationClass});
        }
    }

    private void scanIfAnnotationConfigApplicationContext(ConfigurableApplicationContext context) {
        if (context instanceof AnnotationConfigApplicationContext) {
            String packagesForScan = this.getPackagesForScan();
            ((AnnotationConfigApplicationContext)context).register(new Class[]{MSF4JSpringConfiguration.class});
            ((AnnotationConfigApplicationContext)context).scan(new String[]{packagesForScan});
        }
    }

    private String getPackagesForScan() {
        return this.source.getPackage().getName();
    }

    protected ConfigurableApplicationContext createApplicationContext() {
        Class<Object> contextClass = this.applicationContextClass;
        if (contextClass == null) {
            try {
                contextClass = Class.forName(DEFAULT_CONTEXT_CLASS);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable to create a default ApplicationContext, please specify an ApplicationContextClass", ex);
            }
        }
        return (ConfigurableApplicationContext)BeanUtils.instantiate(contextClass);
    }

    public Class<?> getConfigurationClass() {
        return this.configurationClass;
    }

    public void setConfigurationClass(Class<?> configurationClass) {
        this.configurationClass = configurationClass;
    }

    public Class<? extends ConfigurableApplicationContext> getApplicationContextClass() {
        return this.applicationContextClass;
    }

    public void setApplicationContextClass(Class<? extends ConfigurableApplicationContext> applicationContextClass) {
        this.applicationContextClass = applicationContextClass;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public List<ApplicationContextInitializer<?>> getInitializers() {
        return this.initializers;
    }

    public void setInitializers(List<ApplicationContextInitializer<?>> initializers) {
        this.initializers = initializers;
    }

    public void addService(ConfigurableApplicationContext configurableApplicationContext, Class serviceClass, String basePath) {
        ClassPathBeanDefinitionScanner classPathBeanDefinitionScanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)configurableApplicationContext);
        classPathBeanDefinitionScanner.scan(new String[]{serviceClass.getPackage().getName()});
        SpringMicroservicesRunner springMicroservicesRunner = (SpringMicroservicesRunner)((Object)configurableApplicationContext.getBean(SpringMicroservicesRunner.class));
        springMicroservicesRunner.deploy(basePath, configurableApplicationContext.getBean(serviceClass));
    }
}

