/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal.websocket;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.websocket.CloseReason;
import javax.websocket.RemoteEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketBasicRemoteEndpoint;
import org.wso2.carbon.transport.http.netty.internal.websocket.WebSocketSessionAdapter;

public class WebSocketSessionImpl
extends WebSocketSessionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(WebSocketSessionImpl.class);
    private final ChannelHandlerContext ctx;
    private final boolean isSecure;
    private final URI requestedUri;
    private final String sessionId;
    private boolean isOpen;

    public WebSocketSessionImpl(ChannelHandlerContext ctx, boolean isSecure, String requestedUri, String sessionId) throws URISyntaxException {
        this.ctx = ctx;
        this.isSecure = isSecure;
        this.requestedUri = new URI(requestedUri);
        this.sessionId = sessionId;
        this.isOpen = true;
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        WebSocketBasicRemoteEndpoint basicRemoteEndpoint = new WebSocketBasicRemoteEndpoint(this.ctx);
        return basicRemoteEndpoint;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void close() throws IOException {
        this.ctx.channel().close();
    }

    @Override
    public void close(CloseReason closeReason) {
        this.ctx.channel().writeAndFlush(new CloseWebSocketFrame(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase()));
    }

    @Override
    public URI getRequestURI() {
        return this.requestedUri;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }
}

