/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpRequest;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.exceptions.MessagingException;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

public class ClientRequestWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ClientRequestWorker.class);
    private ConnectionManager.PoolManagementPolicy poolManagementPolicy;
    private HttpRoute httpRoute;
    private SourceHandler sourceHandler;
    private SenderConfiguration senderConfig;
    private CarbonMessage carbonMessage;
    private HttpRequest httpRequest;
    private CarbonCallback carbonCallback;
    private GenericObjectPool genericObjectPool;
    private ConnectionManager connectionManager;
    private EventLoopGroup eventLoopGroup;
    private Class aClass;

    public ClientRequestWorker(HttpRoute httpRoute, SourceHandler sourceHandler, SenderConfiguration senderConfig, HttpRequest httpRequest, CarbonMessage carbonMessage, CarbonCallback carbonCallback, ConnectionManager.PoolManagementPolicy poolManagementPolicy, GenericObjectPool genericObjectPool, ConnectionManager connectionManager, EventLoopGroup eventLoopGroup, Class aClass) {
        this.poolManagementPolicy = poolManagementPolicy;
        this.httpRequest = httpRequest;
        this.sourceHandler = sourceHandler;
        this.senderConfig = senderConfig;
        this.carbonCallback = carbonCallback;
        this.carbonMessage = carbonMessage;
        this.httpRoute = httpRoute;
        this.genericObjectPool = genericObjectPool;
        this.connectionManager = connectionManager;
        this.eventLoopGroup = eventLoopGroup;
        this.aClass = aClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Channel channel = null;
        TargetChannel targetChannel = null;
        if (this.poolManagementPolicy == ConnectionManager.PoolManagementPolicy.PER_SERVER_CHANNEL_ENDPOINT_CONNECTION_CACHING) {
            targetChannel = new TargetChannel();
            ChannelFuture future = ChannelUtils.getNewChannelFuture(targetChannel, this.eventLoopGroup, this.aClass, this.httpRoute, this.senderConfig);
            try {
                channel = ChannelUtils.openChannel(future, this.httpRoute);
            }
            catch (Exception failedCause) {
                String msg = "Error when creating channel for route " + this.httpRoute;
                log.error(msg);
                MessagingException messagingException = new MessagingException(msg, failedCause, 101503);
                this.carbonMessage.setMessagingException(messagingException);
                this.carbonCallback.done(this.carbonMessage);
                return;
            }
            finally {
                if (channel != null) {
                    targetChannel.setChannel(channel);
                    targetChannel.setTargetHandler(targetChannel.getHTTPClientInitializer().getTargetHandler());
                }
            }
        } else {
            targetChannel = this.processThroughConnectionPool();
        }
        if (targetChannel != null) {
            targetChannel.setHttpRoute(this.httpRoute);
            if (targetChannel.getTargetHandler() == null) {
                log.error("Cannot find registered TargetHandler probably connection creation is failed");
                String msg = "Connection creation failed for ";
                MessagingException messagingException = new MessagingException(msg, 101503);
                this.carbonMessage.setMessagingException(messagingException);
                this.carbonCallback.done(this.carbonMessage);
                return;
            }
            targetChannel.getTargetHandler().setCallback(this.carbonCallback);
            targetChannel.getTargetHandler().setIncomingMsg(this.carbonMessage);
            targetChannel.getTargetHandler().setTargetChannel(targetChannel);
            targetChannel.getTargetHandler().setConnectionManager(this.connectionManager);
            boolean written = false;
            if (targetChannel.getChannel() != null) {
                written = ChannelUtils.writeContent(targetChannel.getChannel(), this.httpRequest, this.carbonMessage);
            }
            if (written) {
                targetChannel.setRequestWritten(true);
            }
            if (this.sourceHandler != null) {
                targetChannel.setCorrelatedSource(this.sourceHandler);
            }
        }
    }

    private TargetChannel processThroughConnectionPool() {
        try {
            Object obj = this.genericObjectPool.borrowObject();
            if (obj != null) {
                TargetChannel targetChannel = (TargetChannel)obj;
                targetChannel.setTargetHandler(targetChannel.getHTTPClientInitializer().getTargetHandler());
                return targetChannel;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            log.error(msg, e);
            MessagingException messagingException = new MessagingException(msg, 101503);
            this.carbonMessage.setMessagingException(messagingException);
            this.carbonCallback.done(this.carbonMessage);
        }
        return null;
    }
}

