/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.securevault;

import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.securevault.SecureVaultUtils;
import org.wso2.carbon.kernel.securevault.config.model.SecureVaultConfiguration;
import org.wso2.carbon.kernel.securevault.exception.SecureVaultException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class SecureVaultConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultConfiguration.class);
    private static final SecureVaultConfigurationProvider INSTANCE = new SecureVaultConfigurationProvider();
    private boolean initialized = false;
    private SecureVaultConfiguration secureVaultConfiguration;

    private SecureVaultConfigurationProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecureVaultConfigurationProvider getInstance() throws SecureVaultException {
        if (SecureVaultConfigurationProvider.INSTANCE.initialized) {
            return INSTANCE;
        }
        SecureVaultConfigurationProvider secureVaultConfigurationProvider = INSTANCE;
        synchronized (secureVaultConfigurationProvider) {
            if (!SecureVaultConfigurationProvider.INSTANCE.initialized) {
                INSTANCE.init();
            }
        }
        return INSTANCE;
    }

    public static SecureVaultConfiguration getConfiguration() throws SecureVaultException {
        return SecureVaultConfigurationProvider.getInstance().secureVaultConfiguration;
    }

    private void init() throws SecureVaultException {
        String configFileLocation = SecureVaultUtils.getSecureVaultYAMLLocation();
        String resolvedFileContent = SecureVaultUtils.resolveFileToString(Paths.get(configFileLocation, new String[0]).toFile());
        Yaml yaml = new Yaml(new CustomClassLoaderConstructor(SecureVaultConfiguration.class, SecureVaultConfiguration.class.getClassLoader()));
        yaml.setBeanAccess(BeanAccess.FIELD);
        this.secureVaultConfiguration = yaml.loadAs(resolvedFileContent, SecureVaultConfiguration.class);
        this.initialized = true;
        logger.debug("Secure vault configurations loaded successfully.");
    }
}

