/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.configprovider;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.configprovider.ConfigProvider;
import org.wso2.carbon.kernel.configprovider.YAMLBasedConfigFileReader;
import org.wso2.carbon.kernel.internal.configprovider.ConfigProviderDataHolder;
import org.wso2.carbon.kernel.internal.configprovider.ConfigProviderImpl;
import org.wso2.carbon.kernel.securevault.SecureVault;

@Component(name="org.wso2.carbon.kernel.internal.configprovider.ConfigProviderComponent", immediate=true)
public class ConfigProviderComponent {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProviderComponent.class);

    @Activate
    protected void start(BundleContext bundleContext) {
        try {
            YAMLBasedConfigFileReader configFileReader = new YAMLBasedConfigFileReader("deployment.yaml");
            ConfigProviderImpl configProvider = new ConfigProviderImpl(configFileReader);
            bundleContext.registerService(ConfigProvider.class, (Object)configProvider, null);
            logger.debug("ConfigProvider OSGi service registered");
        }
        catch (Throwable throwable) {
            logger.error("An error occurred while activating ConfigProviderComponent", throwable);
        }
    }

    @Deactivate
    protected void stop() {
        logger.debug("Stopping ConfigProviderComponent");
    }

    @Reference(name="config.resolver.secure.vault", service=SecureVault.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterSecureVault")
    protected void registerSecureVault(SecureVault secureVault) {
        ConfigProviderDataHolder.getInstance().setSecureVault(secureVault);
    }

    protected void unRegisterSecureVault(SecureVault secureVault) {
        ConfigProviderDataHolder.getInstance().setSecureVault(null);
    }
}

