/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.messaging.CarbonCallback;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.MessageProcessorException;
import org.wso2.carbon.messaging.TransportSender;
import org.wso2.carbon.transport.http.netty.common.HttpRoute;
import org.wso2.carbon.transport.http.netty.common.Util;
import org.wso2.carbon.transport.http.netty.common.ssl.SSLConfig;
import org.wso2.carbon.transport.http.netty.config.SenderConfiguration;
import org.wso2.carbon.transport.http.netty.config.TransportProperty;
import org.wso2.carbon.transport.http.netty.listener.SourceHandler;
import org.wso2.carbon.transport.http.netty.sender.channel.BootstrapConfiguration;
import org.wso2.carbon.transport.http.netty.sender.channel.ChannelUtils;
import org.wso2.carbon.transport.http.netty.sender.channel.TargetChannel;
import org.wso2.carbon.transport.http.netty.sender.channel.pool.ConnectionManager;

@Deprecated
public class HTTPSender
implements TransportSender {
    private static final Logger log = LoggerFactory.getLogger(HTTPSender.class);
    private ConnectionManager connectionManager;
    private Map<String, SenderConfiguration> senderConfigurationMap;

    public HTTPSender(Set<SenderConfiguration> senderConfiguration, Set<TransportProperty> transportPropertiesSet) {
        if (senderConfiguration.isEmpty()) {
            log.error("Please specify at least one sender configuration");
            return;
        }
        this.senderConfigurationMap = senderConfiguration.stream().collect(Collectors.toMap(senderConf -> senderConf.getScheme().toLowerCase(Locale.getDefault()), config -> config));
        Map<String, Object> transportProperties = new HashMap<String, Object>();
        if (transportPropertiesSet != null && !transportPropertiesSet.isEmpty()) {
            transportProperties = transportPropertiesSet.stream().collect(Collectors.toMap(TransportProperty::getName, TransportProperty::getValue));
        }
        BootstrapConfiguration.createBootStrapConfiguration(transportProperties);
        this.connectionManager = ConnectionManager.getInstance(transportProperties);
    }

    @Override
    public boolean send(CarbonMessage msg, CarbonCallback callback) throws MessageProcessorException {
        String protocol = (String)msg.getProperty("PROTOCOL");
        SenderConfiguration defaultSenderConfiguration = this.senderConfigurationMap.get(protocol.toLowerCase(Locale.getDefault()));
        HttpRequest httpRequest = Util.createHttpRequest(msg);
        if (msg.getProperty("HOST") == null) {
            log.debug("Cannot find property HOST hence using default as localhost Please specify remote host as 'HOST' in carbon message property ");
            msg.setProperty("HOST", "localhost");
        }
        if (msg.getProperty("PORT") == null) {
            SSLConfig sslConfig = defaultSenderConfiguration.getSslConfig();
            int port = 80;
            if (sslConfig != null) {
                port = 443;
            }
            log.debug("Cannot find property PORT hence using default as " + port + " Please specify remote host as 'PORT' in carbon message property ");
            msg.setProperty("PORT", port);
        }
        HttpRoute route = new HttpRoute((String)msg.getProperty("HOST"), (Integer)msg.getProperty("PORT"));
        SourceHandler srcHandler = (SourceHandler)msg.getProperty("SRC_HANDLER");
        if (srcHandler == null) {
            log.debug("Cannot find property SRC_HANDLER hence Sender uses as standalone.If you need to use sender withlistener side please copy property SRC_HANDLER from incoming message");
        }
        Channel outboundChannel = null;
        try {
            TargetChannel targetChannel = this.connectionManager.getTargetChannel(route, srcHandler, defaultSenderConfiguration, httpRequest, msg, callback);
            if (targetChannel != null) {
                outboundChannel = targetChannel.getChannel();
                targetChannel.getTargetHandler().setCallback(callback);
                targetChannel.getTargetHandler().setIncomingMsg(msg);
                targetChannel.getTargetHandler().setTargetChannel(targetChannel);
                targetChannel.getTargetHandler().setConnectionManager(this.connectionManager);
                boolean written = ChannelUtils.writeContent(outboundChannel, httpRequest, msg);
                if (written) {
                    targetChannel.setRequestWritten(true);
                }
            }
        }
        catch (Exception failedCause) {
            throw new MessageProcessorException(failedCause.getMessage(), failedCause);
        }
        return false;
    }

    @Override
    public String getId() {
        return "http/s";
    }
}

