/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.provider;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.ConfigurationRuntimeException;
import org.wso2.carbon.config.ConfigurationUtils;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.config.reader.ConfigFileReader;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.secvault.exception.SecureVaultException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class ConfigProviderImpl
implements ConfigProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProviderImpl.class.getName());
    private Map<String, String> deploymentConfigs = null;
    private static final String PLACEHOLDER_REGEX = "(.*?)(\\$\\{(" + ConfigProviderImpl.getPlaceholderString() + "):([^,]+?)((,)(.+?))?\\})(.*?)";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile(PLACEHOLDER_REGEX);
    private ConfigFileReader configFileReader;
    private SecureVault secureVault;

    public ConfigProviderImpl(ConfigFileReader configFileReader, SecureVault secureVault) {
        this.configFileReader = configFileReader;
        this.secureVault = secureVault;
    }

    @Override
    public <T> T getConfigurationObject(Class<T> configClass) throws ConfigurationException {
        Configuration configuration;
        String namespace = null;
        if (configClass.isAnnotationPresent(Configuration.class) && !"NULL".equals((configuration = configClass.getAnnotation(Configuration.class)).namespace())) {
            namespace = configuration.namespace();
        }
        this.loadDeploymentConfiguration(this.configFileReader);
        if (namespace != null && this.deploymentConfigs.containsKey(namespace)) {
            String yamlConfigString = this.deploymentConfigs.get(namespace);
            if (logger.isDebugEnabled()) {
                logger.debug("class name: " + configClass.getSimpleName() + " | new configurations: \n" + yamlConfigString);
            }
            String yamlProcessedString = this.processPlaceholder(yamlConfigString);
            yamlProcessedString = ConfigurationUtils.substituteVariables(yamlProcessedString);
            Yaml yaml = new Yaml(new CustomClassLoaderConstructor(configClass, configClass.getClassLoader()));
            yaml.setBeanAccess(BeanAccess.FIELD);
            return yaml.loadAs(yamlProcessedString, configClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Deployment configuration mapping doesn't exist: creating configuration instance with default values");
        }
        try {
            return configClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException("Error while creating configuration instance: " + configClass.getSimpleName(), e);
        }
    }

    @Override
    public Object getConfigurationObject(String namespace) throws ConfigurationException {
        this.loadDeploymentConfiguration(this.configFileReader);
        if (this.deploymentConfigs.containsKey(namespace)) {
            String configString = this.deploymentConfigs.get(namespace);
            String processedString = this.processPlaceholder(configString);
            processedString = ConfigurationUtils.substituteVariables(processedString);
            Yaml yaml = new Yaml();
            return yaml.load(processedString);
        }
        logger.error("configuration doesn't exist for the namespace: {} in deployment yaml   . Hence return null object", (Object)namespace);
        return null;
    }

    private void loadDeploymentConfiguration(ConfigFileReader configFileReader) throws ConfigurationException {
        if (this.deploymentConfigs == null) {
            this.deploymentConfigs = configFileReader.getDeploymentConfiguration();
        }
    }

    private static String getPlaceholderString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Placeholder placeholder : Placeholder.values()) {
            stringBuilder.append(placeholder.getValue()).append("|");
        }
        String value = stringBuilder.substring(0, stringBuilder.length() - 1);
        logger.debug("PlaceHolders String: {}", (Object)value);
        return value;
    }

    private String processPlaceholder(String inputString) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(inputString);
        block12: while (matcher.find()) {
            String key = matcher.group(3);
            String value = matcher.group(4);
            String defaultValue = matcher.group(7);
            switch (key) {
                case "env": {
                    inputString = ConfigProviderImpl.processValue(System::getenv, value, inputString, defaultValue, Placeholder.ENV);
                    continue block12;
                }
                case "sys": {
                    inputString = ConfigProviderImpl.processValue(System::getProperty, value, inputString, defaultValue, Placeholder.SYS);
                    continue block12;
                }
                case "sec": {
                    try {
                        SecureVault secureVault = this.getSecureVault().orElseThrow(() -> new ConfigurationRuntimeException("Secure Vault service is not available"));
                        String newValue = new String(secureVault.resolve(value));
                        inputString = inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + newValue + "$8");
                        continue block12;
                    }
                    catch (SecureVaultException e) {
                        throw new ConfigurationRuntimeException("Unable to resolve the given alias", e);
                    }
                }
            }
            String msg = String.format("Unsupported placeholder: %s", key);
            logger.error(msg);
            throw new ConfigurationRuntimeException(msg);
        }
        return inputString;
    }

    private static String processValue(Function<String, String> func, String key, String inputString, String defaultValue, Placeholder type) {
        String newValue = func.apply(key);
        if (newValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + newValue + "$8");
        }
        if (defaultValue != null) {
            return inputString.replaceFirst(PLACEHOLDER_REGEX, "$1" + defaultValue + "$8");
        }
        String msg = Placeholder.ENV.getValue().equals(type.getValue()) ? String.format("Environment variable %s not found. Placeholder: %s", key, inputString) : (Placeholder.SYS.getValue().equals(type.getValue()) ? String.format("System property %s not found. Placeholder: %s", key, inputString) : String.format("Unsupported placeholder type: %s", type.getValue()));
        logger.error(msg);
        throw new ConfigurationRuntimeException(msg);
    }

    private Optional<SecureVault> getSecureVault() {
        return Optional.ofNullable(this.secureVault);
    }

    private static enum Placeholder {
        SYS("sys"),
        ENV("env"),
        SEC("sec");

        private String value;

        private Placeholder(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

