/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.engine.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wso2.carbon.deployment.engine.Artifact;
import org.wso2.carbon.deployment.engine.ArtifactType;
import org.wso2.carbon.deployment.engine.Deployer;
import org.wso2.carbon.deployment.engine.DeploymentService;
import org.wso2.carbon.deployment.engine.exception.CarbonDeploymentException;
import org.wso2.carbon.deployment.engine.internal.DeploymentEngine;
import org.wso2.carbon.utils.FileUtils;
import org.wso2.carbon.utils.Utils;

public class CarbonDeploymentService
implements DeploymentService {
    private DeploymentEngine carbonDeploymentEngine;

    public CarbonDeploymentService(DeploymentEngine carbonDeploymentEngine) {
        this.carbonDeploymentEngine = carbonDeploymentEngine;
    }

    @Override
    public void deploy(String artifactPath, ArtifactType artifactType) throws CarbonDeploymentException {
        Utils.checkSecurity();
        Deployer deployer = this.carbonDeploymentEngine.getDeployer(artifactType);
        if (deployer == null) {
            throw new CarbonDeploymentException("Unknown artifactType : " + artifactType);
        }
        try {
            Path destination = Paths.get(this.carbonDeploymentEngine.getServerRepositoryDirectory().getAbsolutePath(), deployer.getLocation().getFile());
            FileUtils.copyFileToDir(new File(artifactPath), destination.toFile());
        }
        catch (IOException e) {
            throw new CarbonDeploymentException("Error wile copying artifact", e);
        }
    }

    @Override
    public void undeploy(Object key, ArtifactType artifactType) throws CarbonDeploymentException {
        Utils.checkSecurity();
        Deployer deployer = this.carbonDeploymentEngine.getDeployer(artifactType);
        if (deployer == null) {
            throw new CarbonDeploymentException("Unknown artifactType : " + artifactType);
        }
        Artifact deployedArtifact = this.carbonDeploymentEngine.getDeployedArtifact(artifactType, key);
        if (deployedArtifact == null) {
            throw new CarbonDeploymentException("Cannot find artifact with key : " + key + " to undeploy");
        }
        FileUtils.deleteDir(new File(deployedArtifact.getPath()));
    }

    @Override
    public void redeploy(Object key, ArtifactType artifactType) throws CarbonDeploymentException {
    }
}

