/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.carbon.databridge.agent.conf.DataEndpointConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;

public class DataPublisherUtil {
    private DataPublisherUtil() {
    }

    public static ArrayList<Object[]> getEndpointGroups(String urlSet) throws DataEndpointConfigurationException {
        ArrayList<String> urlGroups = new ArrayList<String>();
        ArrayList<Object[]> endPointGroups = new ArrayList<Object[]>();
        Pattern regex = Pattern.compile("\\{.*?\\}");
        Matcher regexMatcher = regex.matcher(urlSet);
        while (regexMatcher.find()) {
            urlGroups.add(regexMatcher.group().replace("{", "").replace("}", ""));
        }
        if (urlGroups.size() == 0) {
            urlGroups.add(urlSet.replace("{", "").replace("}", ""));
        }
        for (String aURLGroup : urlGroups) {
            endPointGroups.add(DataPublisherUtil.getEndpoints(aURLGroup));
        }
        return endPointGroups;
    }

    private static Object[] getEndpoints(String aURLGroup) throws DataEndpointConfigurationException {
        boolean isLBURL = false;
        boolean isFailOverURL = false;
        if (aURLGroup.contains(",")) {
            isLBURL = true;
        }
        if (aURLGroup.contains("|")) {
            isFailOverURL = true;
        }
        if (isLBURL && isFailOverURL) {
            throw new DataEndpointConfigurationException("Invalid data endpoints URL set provided : " + aURLGroup + ", a URL group can be configured as failover OR load balancing endpoints.");
        }
        String[] urls = isLBURL ? aURLGroup.split(",") : (isFailOverURL ? aURLGroup.split("|") : new String[]{aURLGroup});
        Object[] endpoint = new Object[urls.length + 1];
        endpoint[0] = isFailOverURL;
        for (int i = 0; i < urls.length; ++i) {
            endpoint[i + 1] = urls[i].trim();
        }
        return endpoint;
    }

    public static void validateURLs(ArrayList receiverGroups, ArrayList authGroups) throws DataEndpointConfigurationException {
        if (receiverGroups.size() == authGroups.size()) {
            for (int i = 0; i < receiverGroups.size(); ++i) {
                Object[] authGroup;
                Object[] receiverGroup = (Object[])receiverGroups.get(i);
                if (receiverGroup.length == (authGroup = (Object[])authGroups.get(i)).length) {
                    boolean isAuthFailOver;
                    boolean isFailOver = (Boolean)receiverGroup[0];
                    if (isFailOver == (isAuthFailOver = ((Boolean)((Object[])receiverGroups.get(i))[0]).booleanValue())) continue;
                    throw new DataEndpointConfigurationException("Receiver and authentication URL group set doesn't match. Receiver URL group: " + DataPublisherUtil.getURLSet(receiverGroup) + " is configured as failOver : " + isFailOver + ", but Authentication URL group: " + DataPublisherUtil.getURLSet(authGroup) + " is configured as failOver :" + isAuthFailOver);
                }
                throw new DataEndpointConfigurationException("Receiver and authentication URL group set doesn't match. Receiver URL group: " + DataPublisherUtil.getURLSet(receiverGroup) + ", but Authentication URL group: " + DataPublisherUtil.getURLSet(authGroup));
            }
        } else {
            throw new DataEndpointConfigurationException("Receiver and authentication URL set doesn't match. Receiver URL groups: " + receiverGroups.size() + ", but Authentication URL groups: " + authGroups.size());
        }
    }

    private static String getURLSet(Object[] urlGroup) {
        boolean isFailOver = (Boolean)urlGroup[0];
        String urlSet = "";
        for (int i = 1; i < urlGroup.length; ++i) {
            urlSet = urlSet + urlGroup[i];
            if (i == urlGroup.length - 1) continue;
            urlSet = isFailOver ? urlSet + "|" : urlSet + ",";
        }
        return urlSet;
    }

    public static String[] getProtocolHostPort(String url) {
        String[] keyElements = url.split("##");
        String[] urlElements = keyElements[0].split(":");
        return new String[]{urlElements[0], urlElements[1].replace("//", ""), urlElements[2]};
    }

    public static String getDefaultAuthUrl(String receiverURL) {
        String[] urlElements = DataPublisherUtil.getProtocolHostPort(receiverURL);
        int port = Integer.parseInt(urlElements[2]);
        String host = urlElements[1];
        return DataEndpointConfiguration.Protocol.SSL.toString() + "://" + host + ":" + (port + 100);
    }

    public static String getDefaultAuthURLSet(String receiverURLSet) throws DataEndpointConfigurationException {
        ArrayList<Object[]> receiverURLGroups = DataPublisherUtil.getEndpointGroups(receiverURLSet);
        String authURLSet = "";
        for (int i = 0; i < receiverURLGroups.size(); ++i) {
            Object[] receiverGroup = receiverURLGroups.get(i);
            boolean failOver = (Boolean)receiverGroup[0];
            authURLSet = authURLSet + "{";
            for (int j = 1; j < receiverGroup.length; ++j) {
                authURLSet = authURLSet + DataPublisherUtil.getDefaultAuthUrl(receiverGroup[j].toString());
                if (j == receiverGroup.length - 1) continue;
                authURLSet = failOver ? authURLSet + "|" : authURLSet + ",";
            }
            authURLSet = authURLSet + "}";
            if (i == receiverURLGroups.size() - 1) continue;
            authURLSet = authURLSet + ",";
        }
        return authURLSet;
    }
}

