/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.deployment;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.deployment.Artifact;
import org.wso2.carbon.kernel.deployment.ArtifactType;
import org.wso2.carbon.kernel.deployment.Deployer;
import org.wso2.carbon.kernel.deployment.exception.CarbonDeploymentException;
import org.wso2.carbon.kernel.deployment.exception.DeployerRegistrationException;
import org.wso2.carbon.kernel.deployment.exception.DeploymentEngineException;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.deployment.RepositoryScanner;
import org.wso2.carbon.kernel.internal.deployment.SchedulerTask;

public class DeploymentEngine {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentEngine.class);
    private RepositoryScanner repositoryScanner;
    private File repositoryDirectory = null;
    private Map<ArtifactType, Deployer> deployerMap = new ConcurrentHashMap<ArtifactType, Deployer>();
    private Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> deployedArtifacts = new ConcurrentHashMap<ArtifactType, ConcurrentHashMap<Object, Artifact>>();
    private Map<String, Artifact> faultyArtifacts = new ConcurrentHashMap<String, Artifact>();

    public DeploymentEngine() {
        this.repositoryScanner = new RepositoryScanner(this);
    }

    public void start(String repositoryDir) throws DeploymentEngineException {
        logger.debug("Starting carbon deployment engine for repository : " + repositoryDir);
        this.repositoryDirectory = new File(repositoryDir);
        if (!this.repositoryDirectory.exists()) {
            throw new DeploymentEngineException("Cannot find repository : " + this.repositoryDirectory);
        }
        this.repositoryScanner.scan();
        this.startScheduler();
    }

    private void startScheduler() {
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(5);
        SchedulerTask schedulerTask = new SchedulerTask(this.repositoryScanner);
        CarbonRuntime carbonRuntime = DataHolder.getInstance().getCarbonRuntime();
        int interval = 15;
        if (carbonRuntime != null) {
            interval = carbonRuntime.getConfiguration().getDeploymentConfig().getUpdateInterval();
            logger.debug("Using the specified scheduler update interval of {}", (Object)interval);
        } else {
            logger.debug("Using the default deployment scheduler update interval of 15 seconds");
        }
        executorService.scheduleWithFixedDelay(schedulerTask, 0L, interval, TimeUnit.SECONDS);
    }

    public void registerDeployer(Deployer deployer) throws DeployerRegistrationException {
        if (deployer == null) {
            throw new DeployerRegistrationException("Failed to add Deployer : Deployer Class Name is null");
        }
        logger.debug("Registering deployer instance {} with deployment engine", (Object)deployer.getClass().getName());
        deployer.init();
        if (deployer.getLocation() == null) {
            throw new DeployerRegistrationException("Failed to add Deployer " + deployer.getClass().getName() + " : missing 'directory' attribute in deployer instance");
        }
        ArtifactType type = deployer.getArtifactType();
        if (type == null) {
            throw new DeployerRegistrationException("Artifact Type for Deployer : " + deployer + " is null");
        }
        Deployer existingDeployer = this.deployerMap.get(type);
        if (existingDeployer == null) {
            this.deployerMap.put(type, deployer);
        }
    }

    public void unregisterDeployer(Deployer deployer) throws DeploymentEngineException {
        logger.debug("Un-registering deployer instance {} from deployment engine", (Object)deployer.getClass().getName());
        ArtifactType type = deployer.getArtifactType();
        if (type == null) {
            throw new DeploymentEngineException("Artifact Type for Deployer : " + deployer + " is null");
        }
        Deployer existingDeployer = this.deployerMap.get(type);
        if (existingDeployer != null) {
            this.deployerMap.remove(type);
        }
    }

    public Deployer getDeployer(ArtifactType type) {
        return this.deployerMap.get(type);
    }

    public Map<ArtifactType, Deployer> getDeployers() {
        return this.deployerMap;
    }

    public File getRepositoryDirectory() {
        return this.repositoryDirectory;
    }

    public Artifact getDeployedArtifact(ArtifactType type, Object artifactKey) {
        Artifact artifact = null;
        if (this.deployedArtifacts.get(type) != null) {
            artifact = this.deployedArtifacts.get(type).get(artifactKey);
        }
        return artifact;
    }

    public Map<ArtifactType, ConcurrentHashMap<Object, Artifact>> getDeployedArtifacts() {
        return this.deployedArtifacts;
    }

    public Map<String, Artifact> getFaultyArtifacts() {
        return this.faultyArtifacts;
    }

    public void deployArtifacts(List<Artifact> artifactsToDeploy) {
        artifactsToDeploy.forEach(artifactToDeploy -> {
            try {
                Object artifactKey;
                Deployer deployer = this.getDeployer(artifactToDeploy.getType());
                if (deployer != null) {
                    logger.debug("Deploying artifact {} using {} deployer", (Object)artifactToDeploy.getName(), (Object)deployer.getClass().getName());
                    artifactKey = deployer.deploy((Artifact)artifactToDeploy);
                    if (artifactKey == null) {
                        throw new CarbonDeploymentException("Deployed artifact key is null for : " + artifactToDeploy.getName());
                    }
                } else {
                    throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToDeploy.getType());
                }
                artifactToDeploy.setKey(artifactKey);
                this.addToDeployedArtifacts((Artifact)artifactToDeploy);
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while deploying artifacts", e);
                this.addToFaultyArtifacts((Artifact)artifactToDeploy);
            }
        });
    }

    public void updateArtifacts(List<Artifact> artifactsToUpdate) {
        artifactsToUpdate.forEach(artifactToUpdate -> {
            try {
                Object artifactKey;
                Deployer deployer = this.getDeployer(artifactToUpdate.getType());
                if (deployer != null) {
                    logger.debug("Updating artifact {} using {} deployer", (Object)artifactToUpdate.getName(), (Object)deployer.getClass().getName());
                    artifactKey = deployer.update((Artifact)artifactToUpdate);
                    if (artifactKey == null) {
                        throw new CarbonDeploymentException("Deployed artifact key is null for : " + artifactToUpdate.getName());
                    }
                } else {
                    throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToUpdate.getType());
                }
                artifactToUpdate.setKey(artifactKey);
                this.addToDeployedArtifacts((Artifact)artifactToUpdate);
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while updating artifacts", e);
                this.addToFaultyArtifacts((Artifact)artifactToUpdate);
            }
        });
    }

    private void addToDeployedArtifacts(Artifact artifact) {
        ConcurrentHashMap<Object, Artifact> artifactMap = this.deployedArtifacts.get(artifact.getType());
        if (artifactMap == null) {
            artifactMap = new ConcurrentHashMap();
        }
        artifactMap.put(artifact.getKey(), artifact);
        this.deployedArtifacts.put(artifact.getType(), artifactMap);
        this.faultyArtifacts.remove(artifact.getPath());
    }

    private void addToFaultyArtifacts(Artifact artifact) {
        this.faultyArtifacts.put(artifact.getPath(), artifact);
        this.removeFromDeployedArtifacts(artifact);
    }

    public void undeployArtifacts(List<Artifact> artifactsToUndeploy) {
        artifactsToUndeploy.forEach(artifactToUnDeploy -> {
            try {
                Deployer deployer = this.getDeployer(artifactToUnDeploy.getType());
                if (deployer == null) {
                    throw new CarbonDeploymentException("Deployer instance cannot be found for the type : " + artifactToUnDeploy.getType());
                }
                logger.debug("Undeploying artifact {} using {} deployer", (Object)artifactToUnDeploy.getName(), (Object)deployer.getClass().getName());
                deployer.undeploy(artifactToUnDeploy.getKey());
                this.removeFromDeployedArtifacts((Artifact)artifactToUnDeploy);
            }
            catch (CarbonDeploymentException e) {
                logger.error("Error while undeploying artifacts", e);
                this.addToFaultyArtifacts((Artifact)artifactToUnDeploy);
            }
        });
    }

    private void removeFromDeployedArtifacts(Artifact artifact) {
        Map artifactMap = this.deployedArtifacts.get(artifact.getType());
        if (artifactMap != null && artifactMap.containsKey(artifact.getKey())) {
            artifactMap.remove(artifact.getKey());
            if (artifactMap.isEmpty()) {
                this.deployedArtifacts.remove(artifact.getType());
            }
        }
    }
}

