/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal.transports;

import java.util.Map;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.transports.TransportMgtCommandProvider;
import org.wso2.carbon.kernel.startupresolver.RequiredCapabilityListener;
import org.wso2.carbon.kernel.transports.CarbonTransport;
import org.wso2.carbon.kernel.transports.TransportManager;

@Component(name="org.wso2.carbon.kernel.internal.transports.TransportServiceComponent", immediate=true, property={"capability-name=org.wso2.carbon.kernel.transports.CarbonTransport", "component-key=carbon-transport-mgt"})
public class TransportServiceListenerComponent
implements RequiredCapabilityListener {
    private static final Logger logger = LoggerFactory.getLogger(TransportServiceListenerComponent.class);
    private TransportManager transportManager = new TransportManager();

    @Activate
    public void start(BundleContext bundleContext) throws Exception {
    }

    @Reference(name="carbon.transport", service=CarbonTransport.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unregisterTransport")
    protected void registerTransport(CarbonTransport transport, Map<String, ?> ref) {
        this.transportManager.registerTransport(transport);
    }

    protected void unregisterTransport(CarbonTransport transport, Map<String, ?> ref) {
        this.transportManager.unregisterTransport(transport);
    }

    @Override
    public void onAllRequiredCapabilitiesAvailable() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting all transports");
        }
        this.transportManager.startTransports();
        BundleContext bundleContext = DataHolder.getInstance().getBundleContext();
        bundleContext.registerService(TransportManager.class, (Object)this.transportManager, null);
        bundleContext.registerService(CommandProvider.class.getName(), (Object)new TransportMgtCommandProvider(this.transportManager), null);
    }
}

