/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.das.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;

public class DASReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DASReporter.class);
    private final Clock clock;
    private final String source;
    private final DataPublisher dataPublisher;
    private static final String GAUGE_STREAM = "org.wso2.carbon.metrics.gauge";
    private static final String COUNTER_STREAM = "org.wso2.carbon.metrics.counter";
    private static final String METER_STREAM = "org.wso2.carbon.metrics.meter";
    private static final String HISTOGRAM_STREAM = "org.wso2.carbon.metrics.histogram";
    private static final String TIMER_STREAM = "org.wso2.carbon.metrics.timer";
    private static final String VERSION = "1.0.0";
    private static final String GAUGE_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.carbon.metrics.gauge", "1.0.0");
    private static final String COUNTER_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.carbon.metrics.counter", "1.0.0");
    private static final String METER_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.carbon.metrics.meter", "1.0.0");
    private static final String HISTOGRAM_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.carbon.metrics.histogram", "1.0.0");
    private static final String TIMER_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.carbon.metrics.timer", "1.0.0");

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private DASReporter(MetricRegistry registry, String source, String type, String receiverURL, String authURL, String username, String password, String dataAgentConfigPath, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, MetricFilter filter) {
        super(registry, "das-reporter", filter, rateUnit, durationUnit);
        this.source = source;
        this.clock = clock;
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (receiverURL == null) {
            throw new IllegalArgumentException("Data Receiver URL cannot be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (dataAgentConfigPath != null) {
            AgentHolder.setConfigPath(dataAgentConfigPath);
        }
        try {
            this.dataPublisher = new DataPublisher(type, receiverURL, authURL, username, password);
        }
        catch (DataEndpointAgentConfigurationException | DataEndpointAuthenticationException | DataEndpointConfigurationException | DataEndpointException | TransportException e) {
            throw new IllegalStateException("Error when initializing the Data Publisher", e);
        }
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.dataPublisher.shutdown();
        }
        catch (DataEndpointException e) {
            LOGGER.error("Error when stopping the Data Publisher", e);
        }
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.getTime();
        if (!gauges.isEmpty()) {
            this.reportGauges(timestamp, gauges);
        }
        if (!counters.isEmpty()) {
            this.reportCounters(timestamp, counters);
        }
        if (!histograms.isEmpty()) {
            this.reportHistograms(timestamp, histograms);
        }
        if (!meters.isEmpty()) {
            this.reportMeters(timestamp, meters);
        }
        if (!timers.isEmpty()) {
            this.reportTimers(timestamp, timers);
        }
    }

    private void reportGauges(long timestamp, SortedMap<String, Gauge> gauges) {
        Object[] meta = new Object[]{timestamp};
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            String name = entry.getKey();
            Gauge gauge = entry.getValue();
            Object[] payload = new Object[]{this.source, name, this.convertToDouble(gauge.getValue())};
            Event event = new Event(GAUGE_STREAM_ID, timestamp, meta, null, payload);
            this.dataPublisher.publish(event);
        }
    }

    private Double convertToDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        return null;
    }

    private void reportCounters(long timestamp, SortedMap<String, Counter> counters) {
        Object[] meta = new Object[]{timestamp};
        for (Map.Entry<String, Counter> entry : counters.entrySet()) {
            String name = entry.getKey();
            Counter counter = entry.getValue();
            Object[] payload = new Object[]{this.source, name, counter.getCount()};
            Event event = new Event(COUNTER_STREAM_ID, timestamp, meta, null, payload);
            this.dataPublisher.publish(event);
        }
    }

    private void reportHistograms(long timestamp, SortedMap<String, Histogram> histograms) {
        Object[] meta = new Object[]{timestamp};
        for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
            String name = entry.getKey();
            Histogram histogram = entry.getValue();
            Snapshot snapshot = histogram.getSnapshot();
            Object[] payload = new Object[]{this.source, name, histogram.getCount(), snapshot.getMax(), snapshot.getMean(), snapshot.getMin(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile()};
            Event event = new Event(HISTOGRAM_STREAM_ID, timestamp, meta, null, payload);
            this.dataPublisher.publish(event);
        }
    }

    private void reportMeters(long timestamp, SortedMap<String, Meter> meters) {
        Object[] meta = new Object[]{timestamp};
        for (Map.Entry<String, Meter> entry : meters.entrySet()) {
            String name = entry.getKey();
            Meter meter = entry.getValue();
            Object[] payload = new Object[]{this.source, name, meter.getCount(), this.convertRate(meter.getMeanRate()), this.convertRate(meter.getOneMinuteRate()), this.convertRate(meter.getFiveMinuteRate()), this.convertRate(meter.getFifteenMinuteRate()), String.format("events/%s", this.getRateUnit())};
            Event event = new Event(METER_STREAM_ID, timestamp, meta, null, payload);
            this.dataPublisher.publish(event);
        }
    }

    private void reportTimers(long timestamp, SortedMap<String, Timer> timers) {
        Object[] meta = new Object[]{timestamp};
        for (Map.Entry<String, Timer> entry : timers.entrySet()) {
            String name = entry.getKey();
            Timer timer = entry.getValue();
            Snapshot snapshot = timer.getSnapshot();
            Object[] payload = new Object[]{this.source, name, timer.getCount(), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), String.format("calls/%s", this.getRateUnit()), this.getDurationUnit()};
            Event event = new Event(TIMER_STREAM_ID, timestamp, meta, null, payload);
            this.dataPublisher.publish(event);
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public DASReporter build(String source, String type, String receiverURL, String authURL, String username, String password, String dataAgentConfigPath) {
            return new DASReporter(this.registry, source, type, receiverURL, authURL, username, password, dataAgentConfigPath, this.rateUnit, this.durationUnit, this.clock, this.filter);
        }
    }
}

