/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.metrics.impl.AbstractMetric;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Timer;

public class TimerImpl
extends AbstractMetric
implements Timer {
    private com.codahale.metrics.Timer timer;

    public TimerImpl(String name, Level level, com.codahale.metrics.Timer timer) {
        super(name, level);
        this.timer = timer;
    }

    @Override
    public void update(long duration, TimeUnit unit) {
        if (this.isEnabled()) {
            this.timer.update(duration, unit);
        }
    }

    @Override
    public <T> T time(Callable<T> event) throws Exception {
        if (this.isEnabled()) {
            return this.timer.time(event);
        }
        return null;
    }

    @Override
    public Timer.Context start() {
        if (this.isEnabled()) {
            return new ContextImpl(this.timer.time());
        }
        return new DummyContextImpl();
    }

    @Override
    public long getCount() {
        return this.timer.getCount();
    }

    private static class DummyContextImpl
    implements Timer.Context {
        private DummyContextImpl() {
        }

        @Override
        public long stop() {
            return 0L;
        }

        @Override
        public void close() {
        }
    }

    private static class ContextImpl
    implements Timer.Context {
        private Timer.Context context;

        private ContextImpl(Timer.Context context) {
            this.context = context;
        }

        @Override
        public long stop() {
            return this.context.stop();
        }

        @Override
        public void close() {
            this.context.close();
        }
    }
}

