/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.reporter;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.reporter.AbstractReporter;
import org.wso2.carbon.metrics.impl.reporter.ScheduledReporter;

public class CsvReporterImpl
extends AbstractReporter
implements ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(CsvReporterImpl.class);
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final File directory;
    private final long pollingPeriod;
    private CsvReporter csvReporter;

    public CsvReporterImpl(MetricRegistry metricRegistry, MetricFilter metricFilter, File directory, long pollingPeriod) {
        super("CSV");
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.directory = directory;
        this.pollingPeriod = pollingPeriod;
    }

    @Override
    public void report() {
        if (this.csvReporter != null) {
            this.csvReporter.report();
        }
    }

    @Override
    public void startReporter() {
        this.csvReporter = CsvReporter.forRegistry(this.metricRegistry).formatFor(Locale.US).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.directory);
        this.csvReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
    }

    @Override
    public void stopReporter() {
        try {
            this.csvReporter.stop();
            this.csvReporter = null;
        }
        catch (Throwable e) {
            logger.error("An error occurred when trying to stop the reporter", e);
        }
    }
}

