/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.reporter;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.das.reporter.DASReporter;
import org.wso2.carbon.metrics.impl.reporter.AbstractReporter;
import org.wso2.carbon.metrics.impl.reporter.ScheduledReporter;

public class DASReporterImpl
extends AbstractReporter
implements ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(DASReporterImpl.class);
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final String source;
    private final String type;
    private final String receiverURL;
    private final String authURL;
    private final String username;
    private final String password;
    private final String dataAgentConfigPath;
    private DASReporter dasReporter;
    private final long pollingPeriod;

    public DASReporterImpl(MetricRegistry metricRegistry, MetricFilter metricFilter, String source, String type, String receiverURL, String authURL, String username, String password, String dataAgentConfigPath, long pollingPeriod) {
        super("DAS");
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.source = source;
        this.type = type;
        this.receiverURL = receiverURL;
        this.authURL = authURL;
        this.username = username;
        this.password = password;
        this.dataAgentConfigPath = dataAgentConfigPath;
        this.pollingPeriod = pollingPeriod;
    }

    @Override
    public void report() {
        if (this.dasReporter != null) {
            this.dasReporter.report();
        }
    }

    @Override
    public void startReporter() {
        this.dasReporter = DASReporter.forRegistry(this.metricRegistry).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(this.source, this.type, this.receiverURL, this.authURL, this.username, this.password, this.dataAgentConfigPath);
        this.dasReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
    }

    @Override
    public void stopReporter() {
        try {
            this.dasReporter.stop();
            this.dasReporter = null;
        }
        catch (Throwable e) {
            logger.error("An error occurred when trying to stop the reporter", e);
        }
    }
}

