/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.util;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.reporter.ConsoleReporterImpl;
import org.wso2.carbon.metrics.impl.util.ReporterBuildException;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;

public class ConsoleReporterBuilder
implements ReporterBuilder<ConsoleReporterImpl> {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleReporterBuilder.class);
    private static final String CONSOLE_REPORTING_ENABLED = "Reporting.Console.Enabled";
    private static final String CONSOLE_REPORTING_POLLING_PERIOD = "Reporting.Console.PollingPeriod";
    private boolean enabled;
    private long consoleReporterPollingPeriod = 60L;

    @Override
    public ReporterBuilder<ConsoleReporterImpl> configure(MetricsConfiguration configuration) {
        block2: {
            this.enabled = Boolean.parseBoolean(configuration.getProperty(CONSOLE_REPORTING_ENABLED, String.valueOf(this.enabled)));
            String pollingPeriod = configuration.getProperty(CONSOLE_REPORTING_POLLING_PERIOD, String.valueOf(this.consoleReporterPollingPeriod));
            try {
                this.consoleReporterPollingPeriod = Long.parseLong(pollingPeriod);
            }
            catch (NumberFormatException e) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn(String.format("Error parsing the polling period for Console Reporting. Using %d seconds", this.consoleReporterPollingPeriod));
            }
        }
        return this;
    }

    public ReporterBuilder<ConsoleReporterImpl> setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ReporterBuilder<ConsoleReporterImpl> setConsoleReporterPollingPeriod(long consoleReporterPollingPeriod) {
        this.consoleReporterPollingPeriod = consoleReporterPollingPeriod;
        return this;
    }

    @Override
    public ConsoleReporterImpl build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterDisabledException, ReporterBuildException {
        if (!this.enabled) {
            throw new ReporterDisabledException("Console Reporting for Metrics is not enabled");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating Console reporter for Metrics with %d seconds polling period", this.consoleReporterPollingPeriod));
        }
        return new ConsoleReporterImpl(metricRegistry, metricFilter, this.consoleReporterPollingPeriod);
    }
}

