/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.internal.config;

import java.io.File;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.wso2.carbon.transport.http.netty.internal.config.Parameter;
import org.wso2.carbon.transport.http.netty.listener.ssl.SSLConfig;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ListenerConfiguration {
    public static final String DEFAULT_KEY = "netty";
    @XmlAttribute(required=true)
    private String id;
    @XmlAttribute
    private String host;
    @XmlAttribute(required=true)
    private int port;
    @XmlAttribute
    private int bossThreadPoolSize = Runtime.getRuntime().availableProcessors();
    @XmlAttribute
    private int workerThreadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
    @XmlAttribute
    private int execHandlerThreadPoolSize = 60;
    @XmlAttribute
    private String scheme = "http";
    @XmlAttribute
    private String keyStoreFile;
    @XmlAttribute
    private String keyStorePass;
    @XmlAttribute
    private String trustStoreFile;
    @XmlAttribute
    private String trustStorePass;
    @XmlAttribute
    private String certPass;
    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    private List<Parameter> parameters;

    public static ListenerConfiguration getDefault() {
        ListenerConfiguration defaultConfig = new ListenerConfiguration(DEFAULT_KEY, "0.0.0.0", 8080);
        return defaultConfig;
    }

    public ListenerConfiguration() {
    }

    public ListenerConfiguration(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public int getBossThreadPoolSize() {
        return this.bossThreadPoolSize;
    }

    public void setBossThreadPoolSize(int bossThreadPoolSize) {
        this.bossThreadPoolSize = bossThreadPoolSize;
    }

    public String getCertPass() {
        return this.certPass;
    }

    public void setCertPass(String certPass) {
        this.certPass = certPass;
    }

    public int getExecHandlerThreadPoolSize() {
        return this.execHandlerThreadPoolSize;
    }

    public void setExecHandlerThreadPoolSize(int execHandlerThreadPoolSize) {
        this.execHandlerThreadPoolSize = execHandlerThreadPoolSize;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePass() {
        return this.keyStorePass;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public int getWorkerThreadPoolSize() {
        return this.workerThreadPoolSize;
    }

    public void setWorkerThreadPoolSize(int workerThreadPoolSize) {
        this.workerThreadPoolSize = workerThreadPoolSize;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public SSLConfig getSslConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        if (this.certPass == null) {
            this.certPass = this.keyStorePass;
        }
        if (this.keyStoreFile == null || this.keyStorePass == null) {
            throw new IllegalArgumentException("keyStoreFile or keyStorePass not defined for HTTPS scheme");
        }
        File keyStore = new File(this.keyStoreFile);
        if (!keyStore.exists()) {
            throw new IllegalArgumentException("KeyStore File " + this.keyStoreFile + " not found");
        }
        SSLConfig sslConfig = new SSLConfig(keyStore, this.keyStorePass).setCertPass(this.certPass);
        if (this.trustStoreFile != null) {
            File trustStore = new File(this.trustStoreFile);
            if (!trustStore.exists()) {
                throw new IllegalArgumentException("trustStore File " + this.trustStoreFile + " not found");
            }
            if (this.trustStorePass == null) {
                throw new IllegalArgumentException("trustStorePass is not defined for HTTPS scheme");
            }
            sslConfig.setTrustStore(trustStore).setTrustStorePass(this.trustStorePass);
        }
        return sslConfig;
    }
}

