/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.httpmonitoring;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.databridge.agent.AgentHolder;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringEvent;
import org.wso2.msf4j.util.SystemVariableUtil;

public final class HTTPMonitoringDataPublisher {
    private static final Logger logger = LoggerFactory.getLogger(HTTPMonitoringDataPublisher.class);
    private static final String HTTP_MONITORING_DAS_TYPE = "HTTP_MONITORING_DAS_TYPE";
    private static final String HTTP_MONITORING_DAS_RECEIVER_URL = "HTTP_MONITORING_DAS_RECEIVERURL";
    private static final String HTTP_MONITORING_DAS_AUTH_URL = "HTTP_MONITORING_DAS_AUTHURL";
    private static final String HTTP_MONITORING_DAS_USERNAME = "HTTP_MONITORING_DAS_USERNAME";
    private static final String HTTP_MONITORING_DAS_PASSWORD = "HTTP_MONITORING_DAS_PASSWORD";
    private static final String HTTP_MONITORING_DAS_DATAAGENTCONFIGPATH = "HTTP_MONITORING_DAS_DATAAGENTCONFIGPATH";
    private static final String HTTP_MONITORING_STREAM = "org.wso2.msf4j.analytics.httpmonitoring";
    private static final String VERSION = "1.0.0";
    private static final String HTTP_MONITORING_STREAM_ID = DataBridgeCommonsUtils.generateStreamId("org.wso2.msf4j.analytics.httpmonitoring", "1.0.0");
    private static final String SERVER_HOST_ADDRESS;
    private static final String SERVER_HOSTNAME;
    private static final String MICROSERVICE = "Microservice";
    private static DataPublisher dataPublisher;

    private HTTPMonitoringDataPublisher() {
    }

    private static InetAddress getLocalAddress() throws SocketException, UnknownHostException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            if (!iface.isUp()) continue;
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                return addr;
            }
        }
        return InetAddress.getLocalHost();
    }

    static synchronized void init() {
        if (dataPublisher != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("HTTP Monitoring Data Publisher is already initialized");
            }
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("Initializing HTTP Monitoring Data Publisher");
        }
        String type = "thrift";
        String receiverURL = "tcp://localhost:7611";
        String username = "admin";
        String password = "admin";
        type = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_TYPE, type);
        receiverURL = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_RECEIVER_URL, receiverURL);
        String authURL = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_AUTH_URL, null);
        username = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_USERNAME, username);
        password = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_PASSWORD, password);
        String dataAgentConfigPath = SystemVariableUtil.getValue(HTTP_MONITORING_DAS_DATAAGENTCONFIGPATH, null);
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (receiverURL == null) {
            throw new IllegalArgumentException("Data Receiver URL cannot be null");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (dataAgentConfigPath == null) {
            throw new IllegalArgumentException("Data Agent Configuration Path cannot be null");
        }
        AgentHolder.setConfigPath(dataAgentConfigPath);
        try {
            dataPublisher = new DataPublisher(type, receiverURL, authURL, username, password);
        }
        catch (DataEndpointAgentConfigurationException | DataEndpointAuthenticationException | DataEndpointConfigurationException | DataEndpointException | TransportException e) {
            throw new IllegalStateException("Error when initializing the Data Publisher", e);
        }
    }

    static synchronized void destroy() {
        if (dataPublisher != null) {
            try {
                dataPublisher.shutdownWithAgent();
            }
            catch (DataEndpointException e) {
                logger.error("Error shutting down the data publisher with agent", e);
            }
            finally {
                dataPublisher = null;
            }
        }
    }

    static void publishEvent(HTTPMonitoringEvent httpMonitoringEvent) {
        Object[] meta = new Object[]{httpMonitoringEvent.getTimestamp(), SERVER_HOST_ADDRESS, SERVER_HOSTNAME, MICROSERVICE};
        Object[] payload = new Object[]{httpMonitoringEvent.getServiceClass(), httpMonitoringEvent.getServiceName(), httpMonitoringEvent.getServiceMethod(), httpMonitoringEvent.getRequestUri(), httpMonitoringEvent.getServiceContext(), httpMonitoringEvent.getHttpMethod(), httpMonitoringEvent.getContentType(), httpMonitoringEvent.getRequestSizeBytes(), httpMonitoringEvent.getReferrer(), httpMonitoringEvent.getResponseHttpStatusCode(), httpMonitoringEvent.getResponseTime()};
        Event event = new Event(HTTP_MONITORING_STREAM_ID, httpMonitoringEvent.getTimestamp(), meta, null, payload);
        dataPublisher.publish(event);
    }

    static {
        try {
            InetAddress localAddress = HTTPMonitoringDataPublisher.getLocalAddress();
            SERVER_HOST_ADDRESS = localAddress.getHostAddress();
            SERVER_HOSTNAME = localAddress.getHostName();
        }
        catch (SocketException | UnknownHostException e) {
            throw new IllegalStateException("Cannot determine server host address", e);
        }
    }
}

