/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.httpmonitoring;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Path;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringDataPublisher;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringEvent;

@Component(name="org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitoringInterceptor", service={Interceptor.class}, immediate=true)
public class HTTPMonitoringInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(HTTPMonitoringInterceptor.class);
    private Map<Method, Interceptor> map = new ConcurrentHashMap<Method, Interceptor>();

    public HTTPMonitoringInterceptor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating HTTP Monitoring Interceptor");
        }
    }

    public HTTPMonitoringInterceptor init() {
        HTTPMonitoringDataPublisher.init();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                HTTPMonitoringDataPublisher.destroy();
            }
        });
        return this;
    }

    @Override
    public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
        Method method = serviceMethodInfo.getMethod();
        Interceptor interceptor = this.map.get(method);
        if (interceptor == null && (method.isAnnotationPresent(HTTPMonitored.class) || method.getDeclaringClass().isAnnotationPresent(HTTPMonitored.class))) {
            interceptor = new HTTPInterceptor();
            this.map.put(method, interceptor);
        }
        if (interceptor != null) {
            interceptor.preCall(request, responder, serviceMethodInfo);
        }
        return true;
    }

    @Override
    public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
        Method method = serviceMethodInfo.getMethod();
        Interceptor interceptor = this.map.get(method);
        if (interceptor != null) {
            interceptor.postCall(request, status, serviceMethodInfo);
        }
    }

    private class HTTPInterceptor
    implements Interceptor {
        private static final String MONITORING_EVENT = "MONITORING_EVENT";
        private String serviceClass;
        private String serviceName;
        private String serviceMethod;
        private String servicePath;

        private HTTPInterceptor() {
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
            HTTPMonitoringEvent httpMonitoringEvent = new HTTPMonitoringEvent();
            httpMonitoringEvent.setTimestamp(System.currentTimeMillis());
            httpMonitoringEvent.setStartNanoTime(System.nanoTime());
            if (this.serviceClass == null) {
                Method method = serviceMethodInfo.getMethod();
                Class<?> serviceClass = method.getDeclaringClass();
                this.serviceClass = serviceClass.getName();
                this.serviceName = serviceClass.getSimpleName();
                this.serviceMethod = method.getName();
                if (serviceClass.isAnnotationPresent(Path.class)) {
                    Path path = serviceClass.getAnnotation(Path.class);
                    this.servicePath = path.value();
                }
            }
            httpMonitoringEvent.setServiceClass(this.serviceClass);
            httpMonitoringEvent.setServiceName(this.serviceName);
            httpMonitoringEvent.setServiceMethod(this.serviceMethod);
            httpMonitoringEvent.setRequestUri(request.getUri());
            httpMonitoringEvent.setServiceContext(this.servicePath);
            HttpHeaders httpHeaders = request.headers();
            httpMonitoringEvent.setHttpMethod(request.getMethod().name());
            httpMonitoringEvent.setContentType(httpHeaders.get("Content-Type"));
            String contentLength = httpHeaders.get("Content-Length");
            if (contentLength != null) {
                httpMonitoringEvent.setRequestSizeBytes(Long.parseLong(contentLength));
            }
            httpMonitoringEvent.setReferrer(httpHeaders.get("Referer"));
            serviceMethodInfo.setAttribute(MONITORING_EVENT, httpMonitoringEvent);
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
            HTTPMonitoringEvent httpMonitoringEvent = (HTTPMonitoringEvent)serviceMethodInfo.getAttribute(MONITORING_EVENT);
            httpMonitoringEvent.setResponseTime(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - httpMonitoringEvent.getStartNanoTime()));
            httpMonitoringEvent.setResponseHttpStatusCode(status.code());
            HTTPMonitoringDataPublisher.publishEvent(httpMonitoringEvent);
        }
    }
}

