/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.MetricServiceImpl;
import org.wso2.carbon.metrics.impl.MetricsLevelConfigException;
import org.wso2.carbon.metrics.impl.MetricsLevelConfiguration;
import org.wso2.carbon.metrics.impl.util.ConsoleReporterBuilder;
import org.wso2.carbon.metrics.impl.util.DASReporterBuilder;
import org.wso2.carbon.metrics.impl.util.JmxReporterBuilder;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.metrics.manager.ServiceReferenceHolder;
import org.wso2.msf4j.analytics.metrics.MetricReporter;
import org.wso2.msf4j.analytics.metrics.MetricsEnvConfiguration;

public final class Metrics {
    private static final Logger logger = LoggerFactory.getLogger(Metrics.class);
    private static MetricService metricService;

    private Metrics() {
    }

    static synchronized void init(MetricReporter ... metricReporters) {
        MetricsLevelConfiguration metricsLevelConfiguration;
        MetricsEnvConfiguration metricsEnvConfiguration;
        block11: {
            if (metricService != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Metric Service is already initialized");
                }
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Initializing Metrics Service");
            }
            metricsEnvConfiguration = new MetricsEnvConfiguration();
            metricsLevelConfiguration = new MetricsLevelConfiguration();
            try {
                metricsLevelConfiguration.loadFromSystemPropertyFile();
            }
            catch (MetricsLevelConfigException e) {
                if (!logger.isWarnEnabled()) break block11;
                logger.warn("Error loading metrics level configuration", e);
            }
        }
        MetricServiceImpl.Builder builder = new MetricServiceImpl.Builder().setEnabled(true).setRootLevel(Level.INFO);
        block7: for (MetricReporter metricReporter : metricReporters) {
            switch (metricReporter) {
                case CONSOLE: {
                    builder.addReporterBuilder(new ConsoleReporterBuilder().setEnabled(true).configure(metricsEnvConfiguration));
                    continue block7;
                }
                case DAS: {
                    builder.addReporterBuilder(new DASReporterBuilder().setEnabled(true).configure(metricsEnvConfiguration));
                    continue block7;
                }
                case JMX: {
                    builder.addReporterBuilder(new JmxReporterBuilder().setEnabled(true).configure(metricsEnvConfiguration));
                    continue block7;
                }
            }
        }
        metricService = builder.build(metricsLevelConfiguration);
        ServiceReferenceHolder.getInstance().setMetricService(metricService);
        MetricManager.registerMXBean();
    }

    static synchronized void destroy() {
        if (metricService != null) {
            MetricManager.unregisterMXBean();
            metricService.disable();
            metricService = null;
        }
        ServiceReferenceHolder.getInstance().setMetricService(null);
    }
}

