/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.analytics.metrics;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.annotation.Counted;
import org.wso2.carbon.metrics.annotation.Metered;
import org.wso2.carbon.metrics.annotation.Timed;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.Timer;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.analytics.metrics.MetricReporter;
import org.wso2.msf4j.analytics.metrics.Metrics;

@Component(name="org.wso2.msf4j.analytics.metrics.MetricsInterceptor", service={Interceptor.class}, immediate=true)
public class MetricsInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(MetricsInterceptor.class);
    private Map<Method, Set<Interceptor>> map = new ConcurrentHashMap<Method, Set<Interceptor>>();

    public MetricsInterceptor() {
        if (logger.isDebugEnabled()) {
            logger.debug("Creating Metrics Interceptor");
        }
    }

    public MetricsInterceptor init(MetricReporter ... metricReporters) {
        Metrics.init(metricReporters);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Metrics.destroy();
            }
        });
        return this;
    }

    @Override
    public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
        Method method = serviceMethodInfo.getMethod();
        Set<Interceptor> interceptors = this.map.get(method);
        if (interceptors == null) {
            Interceptor interceptor;
            org.wso2.carbon.metrics.annotation.Level level;
            String name;
            Annotation annotation;
            if (method.isAnnotationPresent(Timed.class)) {
                annotation = method.getAnnotation(Timed.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Timer timer = MetricManager.timer(this.toLevel(level), name);
                interceptor = new TimerInterceptor(timer);
                interceptors = new HashSet<Interceptor>();
                interceptors.add(interceptor);
            }
            if (method.isAnnotationPresent(Metered.class)) {
                annotation = method.getAnnotation(Metered.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Meter meter = MetricManager.meter(this.toLevel(level), name);
                interceptor = new MeterInterceptor(meter);
                if (interceptors == null) {
                    interceptors = new HashSet<Interceptor>();
                }
                interceptors.add(interceptor);
            }
            if (method.isAnnotationPresent(Counted.class)) {
                annotation = method.getAnnotation(Counted.class);
                name = this.buildName(annotation.name(), annotation.absolute(), method);
                level = annotation.level();
                Counter counter = MetricManager.counter(this.toLevel(level), name);
                interceptor = new CounterInterceptor(counter, annotation.monotonic());
                if (interceptors == null) {
                    interceptors = new HashSet<Interceptor>();
                }
                interceptors.add(interceptor);
            }
            if (interceptors != null && !interceptors.isEmpty()) {
                this.map.put(method, interceptors);
            }
        }
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                interceptor.preCall(request, responder, serviceMethodInfo);
            }
        }
        return true;
    }

    @Override
    public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
        Method method = serviceMethodInfo.getMethod();
        Set<Interceptor> interceptors = this.map.get(method);
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                interceptor.postCall(request, status, serviceMethodInfo);
            }
        }
    }

    private String buildName(String explicitName, boolean absolute, Method method) {
        if (explicitName != null && !explicitName.isEmpty()) {
            if (absolute) {
                return explicitName;
            }
            return MetricManager.name(method.getDeclaringClass().getName(), method.getName(), explicitName);
        }
        return MetricManager.name(method.getDeclaringClass().getName(), method.getName());
    }

    private Level toLevel(org.wso2.carbon.metrics.annotation.Level level) {
        switch (level) {
            case OFF: {
                return Level.OFF;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case ALL: {
                return Level.ALL;
            }
        }
        return Level.INFO;
    }

    private static class CounterInterceptor
    implements Interceptor {
        private final Counter counter;
        private final boolean monotonic;

        private CounterInterceptor(Counter counter, boolean monotonic) {
            this.counter = counter;
            this.monotonic = monotonic;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
            this.counter.inc();
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
            if (!this.monotonic) {
                this.counter.dec();
            }
        }
    }

    private static class MeterInterceptor
    implements Interceptor {
        private final Meter meter;

        private MeterInterceptor(Meter meter) {
            this.meter = meter;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
            this.meter.mark();
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
        }
    }

    private static class TimerInterceptor
    implements Interceptor {
        private final Timer timer;
        private static final String TIMER_CONTEXT = "TIMER_CONTEXT";

        private TimerInterceptor(Timer timer) {
            this.timer = timer;
        }

        @Override
        public boolean preCall(HttpRequest request, HttpResponder responder, ServiceMethodInfo serviceMethodInfo) {
            Timer.Context context = this.timer.start();
            serviceMethodInfo.setAttribute(TIMER_CONTEXT, context);
            return true;
        }

        @Override
        public void postCall(HttpRequest request, HttpResponseStatus status, ServiceMethodInfo serviceMethodInfo) {
            Timer.Context context = (Timer.Context)serviceMethodInfo.getAttribute(TIMER_CONTEXT);
            context.stop();
        }
    }
}

