/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.fileserver;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Paths;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.annotation.Timed;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.HttpStreamHandler;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;

@HTTPMonitored
@Path(value="/")
public class FileServerService {
    private static final Logger log = LoggerFactory.getLogger(FileServerService.class);
    private static final String MOUNT_PATH = "/var/www/html/upload";

    @POST
    @Path(value="/{fileName}")
    @Timed
    public void postFile(@Context HttpStreamer httpStreamer, @PathParam(value="fileName") String fileName) throws IOException {
        httpStreamer.callback(new HttpStreamHandlerImpl(fileName));
    }

    @GET
    @Path(value="/{fileName}")
    @Timed
    public Response getFile(@PathParam(value="fileName") String fileName) {
        File file = Paths.get(MOUNT_PATH, fileName).toFile();
        if (file.exists()) {
            return Response.ok(file).build();
        }
        return Response.status(Response.Status.NOT_FOUND).build();
    }

    private static class HttpStreamHandlerImpl
    implements HttpStreamHandler {
        private BufferedOutputStream outputStream = null;

        public HttpStreamHandlerImpl(String fileName) throws FileNotFoundException {
            File file = Paths.get(FileServerService.MOUNT_PATH, fileName).toFile();
            if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(file));
            }
        }

        @Override
        public void chunk(ByteBuf request, HttpResponder responder) throws IOException {
            if (this.outputStream == null) {
                throw new IOException("Unable to write file");
            }
            request.readBytes(this.outputStream, request.capacity());
        }

        @Override
        public void finished(ByteBuf request, HttpResponder responder) throws IOException {
            if (this.outputStream == null) {
                throw new IOException("Unable to write file");
            }
            request.readBytes(this.outputStream, request.capacity());
            this.outputStream.close();
            responder.sendStatus(HttpResponseStatus.ACCEPTED);
        }

        @Override
        public void error(Throwable cause) {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to close file output stream", e);
            }
        }
    }
}

