/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Charsets;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

final class HandlerException
extends Exception {
    private final transient HttpResponseStatus failureStatus;
    private final String message;

    HandlerException(HttpResponseStatus failureStatus, String message) {
        super(message);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    HandlerException(HttpResponseStatus failureStatus, String message, Throwable cause) {
        super(message, cause);
        this.failureStatus = failureStatus;
        this.message = message;
    }

    HttpResponse createFailureResponse() {
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.failureStatus, Unpooled.copiedBuffer(this.message, Charsets.UTF_8));
    }

    public HttpResponseStatus getFailureStatus() {
        return this.failureStatus;
    }
}

