/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.wso2.msf4j.ChunkResponder;
import org.wso2.msf4j.internal.router.AbstractHttpResponder;
import org.wso2.msf4j.internal.router.BasicInternalHttpResponse;
import org.wso2.msf4j.internal.router.InternalHttpResponse;

public class InternalHttpResponder
extends AbstractHttpResponder {
    private int statusCode = 0;
    private InputSupplier<? extends InputStream> inputSupplier;

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status, @Nullable Multimap<String, String> headers) {
        this.statusCode = status.code();
        return new ChunkResponder(){
            private ByteBuf contentChunks = Unpooled.EMPTY_BUFFER;
            private boolean closed;

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                this.sendChunk(Unpooled.wrappedBuffer(chunk));
            }

            @Override
            public synchronized void sendChunk(ByteBuf chunk) throws IOException {
                if (this.closed) {
                    throw new IOException("ChunkResponder already closed.");
                }
                this.contentChunks = Unpooled.wrappedBuffer(this.contentChunks, chunk);
            }

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                InternalHttpResponder.this.inputSupplier = InternalHttpResponder.this.createContentSupplier(this.contentChunks);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, @Nullable ByteBuf content, String contentType, @Nullable Multimap<String, String> headers) {
        this.statusCode = status.code();
        this.inputSupplier = this.createContentSupplier(content == null ? Unpooled.EMPTY_BUFFER : content);
    }

    @Override
    public void sendFile(File file, String contentType, @Nullable Multimap<String, String> headers) {
        this.statusCode = HttpResponseStatus.OK.code();
        this.inputSupplier = Files.newInputStreamSupplier(file);
    }

    public InternalHttpResponse getResponse() {
        return new BasicInternalHttpResponse(this.statusCode, this.inputSupplier);
    }

    private InputSupplier<InputStream> createContentSupplier(ByteBuf content) {
        ByteBuf responseContent = content.duplicate();
        responseContent.markReaderIndex();
        return new HttpResponderInputSupplier(responseContent).invoke();
    }

    private static class HttpResponderInputSupplier {
        private final ByteBuf responseContent;

        public HttpResponderInputSupplier(ByteBuf responseContent) {
            this.responseContent = responseContent;
        }

        public InputSupplier<InputStream> invoke() {
            return new InputSupplier<InputStream>(){

                @Override
                public InputStream getInput() throws IOException {
                    responseContent.resetReaderIndex();
                    return new ByteBufInputStream(responseContent);
                }
            };
        }
    }
}

