/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal.router;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.HttpResponder;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.internal.router.ExceptionHandler;
import org.wso2.msf4j.internal.router.HandlerException;
import org.wso2.msf4j.internal.router.HttpMethodInfoBuilder;
import org.wso2.msf4j.internal.router.HttpResourceModel;
import org.wso2.msf4j.internal.router.PatternPathRouterWithGroups;
import org.wso2.msf4j.internal.router.URLRewriter;
import org.wso2.msf4j.internal.router.WrappedHttpResponder;

public final class MicroserviceMetadata {
    private static final Logger log = LoggerFactory.getLogger(MicroserviceMetadata.class);
    private final PatternPathRouterWithGroups<HttpResourceModel> patternRouter = PatternPathRouterWithGroups.create();
    private final Iterable<Object> handlers;
    private final Iterable<Interceptor> interceptors;
    private final URLRewriter urlRewriter;

    public MicroserviceMetadata(Iterable<? extends Object> handlers, Iterable<? extends Interceptor> interceptors, URLRewriter urlRewriter, ExceptionHandler exceptionHandler) {
        this.handlers = ImmutableList.copyOf(handlers);
        this.interceptors = ImmutableList.copyOf(interceptors);
        this.urlRewriter = urlRewriter;
        for (Object object : handlers) {
            String basePath = "";
            if (object.getClass().isAnnotationPresent(Path.class)) {
                basePath = object.getClass().getAnnotation(Path.class).value();
            }
            for (Method method : object.getClass().getDeclaredMethods()) {
                if (method.isAnnotationPresent(PostConstruct.class) || method.isAnnotationPresent(PreDestroy.class)) continue;
                if (Modifier.isPublic(method.getModifiers()) && this.isHttpMethodAvailable(method)) {
                    String relativePath = "";
                    if (method.getAnnotation(Path.class) != null) {
                        relativePath = method.getAnnotation(Path.class).value();
                    }
                    String absolutePath = String.format("%s/%s", basePath, relativePath);
                    this.patternRouter.add(absolutePath, new HttpResourceModel(absolutePath, method, object, new ExceptionHandler()));
                    continue;
                }
                log.trace("Not adding method {}({}) to path routing like. HTTP calls will not be routed to this method", (Object)method.getName(), (Object)method.getParameterTypes());
            }
        }
    }

    private boolean isHttpMethodAvailable(Method method) {
        return method.isAnnotationPresent(GET.class) || method.isAnnotationPresent(PUT.class) || method.isAnnotationPresent(POST.class) || method.isAnnotationPresent(DELETE.class);
    }

    public HttpMethodInfoBuilder getDestinationMethod(HttpRequest request, HttpResponder responder) throws HandlerException {
        block10: {
            String acceptHeaderStr;
            if (this.urlRewriter != null) {
                try {
                    request.setUri(URI.create(request.getUri()).normalize().toString());
                    if (!this.urlRewriter.rewrite(request, responder)) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    log.error("Exception thrown during rewriting of uri {}", (Object)request.getUri(), (Object)t);
                    throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
                }
            }
            List<String> acceptHeader = (acceptHeaderStr = request.headers().get("Accept")) != null ? Arrays.asList(acceptHeaderStr.split("\\s*,\\s*")).stream().map(mediaType -> mediaType.split("\\s*;\\s*")[0]).collect(Collectors.toList()) : null;
            String contentTypeHeaderStr = request.headers().get("Content-Type");
            String contentTypeHeader = contentTypeHeaderStr != null ? contentTypeHeaderStr.split("\\s*;\\s*")[0] : null;
            try {
                String path = URI.create(request.getUri()).normalize().getPath();
                List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
                List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> matchedDestinations = this.getMatchedDestination(routableDestinations, request.getMethod(), path);
                if (!matchedDestinations.isEmpty()) {
                    PatternPathRouterWithGroups.RoutableDestination matchedDestination = matchedDestinations.stream().filter(matchedDestination1 -> ((HttpResourceModel)matchedDestination1.getDestination()).matchConsumeMediaType(contentTypeHeader) && ((HttpResourceModel)matchedDestination1.getDestination()).matchProduceMediaType(acceptHeader)).findFirst().get();
                    HttpResourceModel httpResourceModel = (HttpResourceModel)matchedDestination.getDestination();
                    boolean terminated = false;
                    ServiceMethodInfo serviceMethodInfo = new ServiceMethodInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod());
                    for (Interceptor interceptor : this.interceptors) {
                        if (interceptor.preCall(request, responder, serviceMethodInfo)) continue;
                        terminated = true;
                        break;
                    }
                    if (!terminated) {
                        responder = new WrappedHttpResponder(responder, this.interceptors, request, serviceMethodInfo);
                        return HttpMethodInfoBuilder.getInstance().httpResourceModel(httpResourceModel).httpRequest(request).httpResponder(responder).requestInfo(matchedDestination.getGroupNameValues(), contentTypeHeader, acceptHeader);
                    }
                    break block10;
                }
                if (!routableDestinations.isEmpty()) {
                    throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, request.getUri());
                }
                throw new HandlerException(HttpResponseStatus.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", request.getUri()));
            }
            catch (NoSuchElementException ex) {
                throw new HandlerException(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE, String.format("Problem accessing: %s. Reason: Unsupported Media Type", request.getUri()), ex);
            }
        }
        return null;
    }

    private List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> getMatchedDestination(List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations, HttpMethod targetHttpMethod, String requestUri) {
        Iterable<String> requestUriParts = Splitter.on('/').omitEmptyStrings().split(requestUri);
        ArrayList<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> matchedDestinations = Lists.newArrayListWithExpectedSize(routableDestinations.size());
        int maxExactMatch = 0;
        int maxGroupMatch = 0;
        int maxPatternLength = 0;
        for (PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> destination : routableDestinations) {
            HttpResourceModel resourceModel = destination.getDestination();
            int groupMatch = destination.getGroupNameValues().size();
            for (HttpMethod httpMethod : resourceModel.getHttpMethod()) {
                if (!targetHttpMethod.equals(httpMethod)) continue;
                int exactMatch = this.getExactPrefixMatchCount(requestUriParts, Splitter.on('/').omitEmptyStrings().split(resourceModel.getPath()));
                if (exactMatch > maxExactMatch) {
                    maxExactMatch = exactMatch;
                    maxGroupMatch = groupMatch;
                    maxPatternLength = resourceModel.getPath().length();
                    matchedDestinations.clear();
                    matchedDestinations.add(destination);
                    continue;
                }
                if (exactMatch != maxExactMatch || groupMatch < maxGroupMatch) continue;
                if (groupMatch > maxGroupMatch || resourceModel.getPath().length() > maxPatternLength) {
                    maxGroupMatch = groupMatch;
                    maxPatternLength = resourceModel.getPath().length();
                    matchedDestinations.clear();
                }
                matchedDestinations.add(destination);
            }
        }
        return matchedDestinations;
    }

    private int getExactPrefixMatchCount(Iterable<String> first, Iterable<String> second) {
        int count = 0;
        Iterator<String> fit = first.iterator();
        Iterator<String> sit = second.iterator();
        while (fit.hasNext() && sit.hasNext() && fit.next().equals(sit.next())) {
            ++count;
        }
        return count;
    }
}

