/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.internal;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Interceptor;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.ServiceMethodInfo;
import org.wso2.msf4j.internal.InterceptorException;
import org.wso2.msf4j.internal.router.HttpResourceModel;

public class InterceptorExecutor {
    private static final Logger log = LoggerFactory.getLogger(InterceptorExecutor.class);
    private Request request;
    private Response response;
    private List<Interceptor> interceptors;
    private ServiceMethodInfo serviceMethodInfo;

    public InterceptorExecutor(HttpResourceModel httpResourceModel, Request request, Response response, List<Interceptor> interceptors) {
        this.request = request;
        this.response = response;
        this.interceptors = interceptors;
        this.serviceMethodInfo = new ServiceMethodInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod());
    }

    public boolean execPreCalls() throws InterceptorException {
        try {
            for (Interceptor interceptor : this.interceptors) {
                if (interceptor.preCall(this.request, this.response, this.serviceMethodInfo)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new InterceptorException("Exception while executing preCalls", e);
        }
        return true;
    }

    public void execPostCalls(int status) throws InterceptorException {
        for (Interceptor interceptor : this.interceptors) {
            try {
                interceptor.postCall(this.request, status, this.serviceMethodInfo);
            }
            catch (Exception e) {
                log.error("Exception while executing a postCall", e);
            }
        }
    }
}

