/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.config.model.ReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;
import org.wso2.carbon.metrics.core.reporter.impl.JmxReporter;

public class JmxReporterConfig
extends ReporterConfig
implements ReporterBuilder<JmxReporter> {
    private static final Logger logger = LoggerFactory.getLogger(JmxReporterConfig.class);
    private String domain = "org.wso2.carbon.metrics";

    public JmxReporterConfig() {
        super("JMX");
        this.setEnabled(true);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public Optional<JmxReporter> build(MetricRegistry metricRegistry, MetricFilter metricFilter) throws ReporterBuildException {
        if (!this.isEnabled()) {
            return Optional.empty();
        }
        if (this.domain == null || this.domain.trim().isEmpty()) {
            throw new ReporterBuildException("Domain is not specified for JMX Reporting.");
        }
        if (logger.isInfoEnabled()) {
            logger.info(String.format("Creating JMX reporter for Metrics with domain '%s'", this.domain));
        }
        return Optional.of(new JmxReporter(this.getName(), metricRegistry, this.getFilter(metricFilter), this.domain));
    }
}

