/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import com.codahale.metrics.MetricFilter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.wso2.carbon.metrics.core.reporter.ReporterBuildException;

public abstract class ReporterConfig {
    private String name;
    private boolean enabled = false;
    private boolean useRegexFilters = false;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private static final DefaultStringMatchingStrategy defaultStringMatchingStrategy = new DefaultStringMatchingStrategy();
    private static final RegexStringMatchingStrategy regexStringMatchingStrategy = new RegexStringMatchingStrategy();
    private static final Map<String, Pattern> patternMap = new ConcurrentHashMap<String, Pattern>();

    public ReporterConfig(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isUseRegexFilters() {
        return this.useRegexFilters;
    }

    public void setUseRegexFilters(boolean useRegexFilters) {
        this.useRegexFilters = useRegexFilters;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReporterConfig that = (ReporterConfig)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected MetricFilter getFilter(MetricFilter enabledFilter) throws ReporterBuildException {
        StringMatchingStrategy stringMatchingStrategy;
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return enabledFilter;
        }
        if (this.useRegexFilters) {
            stringMatchingStrategy = regexStringMatchingStrategy;
            this.compileAllRegex(this.getIncludes());
            this.compileAllRegex(this.getExcludes());
        } else {
            stringMatchingStrategy = defaultStringMatchingStrategy;
        }
        return (name, metric) -> enabledFilter.matches(name, metric) && !stringMatchingStrategy.containsMatch(this.getExcludes(), name) && (this.getIncludes().isEmpty() || stringMatchingStrategy.containsMatch(this.getIncludes(), name));
    }

    private void compileAllRegex(Set<String> matchExpressions) throws ReporterBuildException {
        for (String regex : matchExpressions) {
            Pattern pattern = patternMap.get(regex);
            if (pattern != null) continue;
            try {
                pattern = Pattern.compile(regex);
                patternMap.put(regex, pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ReporterBuildException(String.format("Failed to compile regex \"%s\" used in the \"%s\" reporter", regex, this.name), e);
            }
        }
    }

    private static class RegexStringMatchingStrategy
    implements StringMatchingStrategy {
        private RegexStringMatchingStrategy() {
        }

        @Override
        public boolean containsMatch(Set<String> matchExpressions, String metricName) {
            for (String regex : matchExpressions) {
                Pattern pattern = (Pattern)patternMap.get(regex);
                if (!pattern.matcher(metricName).matches()) continue;
                return true;
            }
            return false;
        }
    }

    private static class DefaultStringMatchingStrategy
    implements StringMatchingStrategy {
        private DefaultStringMatchingStrategy() {
        }

        @Override
        public boolean containsMatch(Set<String> matchExpressions, String metricName) {
            return matchExpressions.contains(metricName);
        }
    }

    private static interface StringMatchingStrategy {
        public boolean containsMatch(Set<String> var1, String var2);
    }
}

