/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.jdbc.core.reporter.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.task.ScheduledTask;

public class ScheduledJdbcMetricsCleanupTask
extends ScheduledTask {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledJdbcMetricsCleanupTask.class);
    private final DataSource dataSource;
    private final int daysToKeep;

    public ScheduledJdbcMetricsCleanupTask(DataSource dataSource, int daysToKeep) {
        super("metrics-jdbc-cleanup");
        this.dataSource = dataSource;
        this.daysToKeep = daysToKeep;
    }

    @Override
    public void run() {
        this.cleanMetricsTables("METRIC_GAUGE", "METRIC_COUNTER", "METRIC_METER", "METRIC_HISTOGRAM", "METRIC_TIMER");
    }

    private void cleanMetricsTables(String ... tableNames) {
        for (String tableName : tableNames) {
            this.cleanMetricsTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMetricsTable(String tableName) {
        Connection connection = null;
        PreparedStatement ps = null;
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("DELETE FROM ");
        queryBuilder.append(tableName);
        queryBuilder.append(" WHERE TIMESTAMP < ?");
        String query = queryBuilder.toString();
        try {
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(query);
            long timestamp = System.currentTimeMillis() / 1000L - (long)this.daysToKeep * 86400L;
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Executing SQL Query [%s]. Parameter: %s", query, timestamp));
            }
            ps.setLong(1, timestamp);
            ps.execute();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Executed SQL Query [%s]. Update Count: %s", query, ps.getUpdateCount()));
            }
            ps.close();
            connection.close();
            ps = null;
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                logger.error("Error when deleting metrics in " + tableName, e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void closeQuietly(Connection connection, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

