/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.config.model;

import java.util.HashSet;
import java.util.Set;
import org.wso2.carbon.config.annotation.Configuration;
import org.wso2.carbon.metrics.core.config.model.ConsoleReporterConfig;
import org.wso2.carbon.metrics.core.config.model.CsvReporterConfig;
import org.wso2.carbon.metrics.core.config.model.JmxReporterConfig;
import org.wso2.carbon.metrics.core.config.model.ReporterConfig;
import org.wso2.carbon.metrics.core.config.model.Slf4jReporterConfig;
import org.wso2.carbon.metrics.core.reporter.ReporterBuilder;

@Configuration(description="Metrics reporting configurations")
public class ReportingConfig {
    private Set<JmxReporterConfig> jmx = new HashSet<JmxReporterConfig>();
    private Set<ConsoleReporterConfig> console = new HashSet<ConsoleReporterConfig>();
    private Set<CsvReporterConfig> csv = new HashSet<CsvReporterConfig>();
    private Set<Slf4jReporterConfig> slf4j = new HashSet<Slf4jReporterConfig>();

    public ReportingConfig() {
        this.jmx.add(new JmxReporterConfig());
        this.console.add(new ConsoleReporterConfig());
        this.csv.add(new CsvReporterConfig());
        this.slf4j.add(new Slf4jReporterConfig());
    }

    public Set<JmxReporterConfig> getJmx() {
        return this.jmx;
    }

    public void setJmx(Set<JmxReporterConfig> jmx) {
        this.jmx = jmx;
    }

    public Set<ConsoleReporterConfig> getConsole() {
        return this.console;
    }

    public void setConsole(Set<ConsoleReporterConfig> console) {
        this.console = console;
    }

    public Set<CsvReporterConfig> getCsv() {
        return this.csv;
    }

    public void setCsv(Set<CsvReporterConfig> csv) {
        this.csv = csv;
    }

    public Set<Slf4jReporterConfig> getSlf4j() {
        return this.slf4j;
    }

    public void setSlf4j(Set<Slf4jReporterConfig> slf4j) {
        this.slf4j = slf4j;
    }

    public Set<? extends ReporterBuilder> getReporterBuilders() {
        HashSet<ReporterConfig> reporterBuilders = new HashSet<ReporterConfig>();
        if (this.jmx != null) {
            reporterBuilders.addAll(this.jmx);
        }
        if (this.console != null) {
            reporterBuilders.addAll(this.console);
        }
        if (this.csv != null) {
            reporterBuilders.addAll(this.csv);
        }
        if (this.slf4j != null) {
            reporterBuilders.addAll(this.slf4j);
        }
        return reporterBuilders;
    }
}

