/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.wso2.carbon.messaging.CarbonMessage;
import org.wso2.carbon.messaging.Headers;
import org.wso2.msf4j.Session;
import org.wso2.msf4j.SessionManager;

public class Request {
    private final CarbonMessage carbonMessage;
    private List<String> acceptTypes = null;
    private String contentType = null;
    private SessionManager sessionManager;
    private Session session;

    public Request(CarbonMessage carbonMessage) {
        this.carbonMessage = carbonMessage;
        String acceptHeaderStr = carbonMessage.getHeader("Accept");
        this.acceptTypes = acceptHeaderStr != null ? Arrays.asList(acceptHeaderStr.split("\\s*,\\s*")).stream().map(mediaType -> mediaType.split("\\s*;\\s*")[0]).collect(Collectors.toList()) : null;
        String contentTypeHeaderStr = carbonMessage.getHeader("Content-Type");
        this.contentType = contentTypeHeaderStr != null ? contentTypeHeaderStr.split("\\s*;\\s*")[0] : null;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public boolean isEomAdded() {
        return this.carbonMessage.isEndOfMsgAdded();
    }

    public boolean isEmpty() {
        return this.carbonMessage.isEmpty();
    }

    public ByteBuffer getMessageBody() {
        return this.carbonMessage.getMessageBody();
    }

    public List<ByteBuffer> getFullMessageBody() {
        return this.carbonMessage.getFullMessageBody();
    }

    public Headers getHeaders() {
        return this.carbonMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.carbonMessage.getHeader(key);
    }

    public Object getProperty(String key) {
        return this.carbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.carbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.carbonMessage.setProperty(key, value);
    }

    public void removeProperty(String key) {
        this.carbonMessage.removeProperty(key);
    }

    public String getUri() {
        return (String)this.carbonMessage.getProperty("TO");
    }

    public String getHttpMethod() {
        return (String)this.carbonMessage.getProperty("HTTP_METHOD");
    }

    public List<String> getAcceptTypes() {
        return this.acceptTypes;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Session getSession() {
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager has not been set");
        }
        if (this.session != null) {
            return this.session.setAccessed();
        }
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader != null) {
            this.session = Arrays.stream(cookieHeader.split(";")).filter(cookie -> cookie.startsWith("JSESSIONID=")).findFirst().map(jsession -> this.sessionManager.getSession(jsession.substring("JSESSIONID=".length()))).orElseGet(this.sessionManager::createSession);
            return this.session.setAccessed();
        }
        this.session = this.sessionManager.createSession();
        return this.session;
    }

    public Session getSession(boolean create) {
        if (this.sessionManager == null) {
            throw new IllegalStateException("SessionManager has not been set");
        }
        if (this.session != null) {
            return this.session.setAccessed();
        }
        String cookieHeader = this.getHeader("Cookie");
        if (cookieHeader != null) {
            this.session = Arrays.stream(cookieHeader.split(";")).filter(cookie -> cookie.startsWith("JSESSIONID=")).findFirst().map(jsession -> this.sessionManager.getSession(jsession.substring("JSESSIONID=".length()))).orElseGet(() -> {
                if (create) {
                    return this.sessionManager.createSession();
                }
                return null;
            });
            return this.session.setAccessed();
        }
        if (create) {
            this.session = this.sessionManager.createSession();
            return this.session;
        }
        return null;
    }

    Session getSessionInternal() {
        return this.session;
    }
}

