/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.sender.TargetHandler;

public class HTTPClientInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HTTPClientInitializer.class);
    private SSLEngine sslEngine;
    private TargetHandler handler;

    public HTTPClientInitializer(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslEngine != null) {
            log.debug("adding ssl handler");
            ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(this.sslEngine));
        }
        ch.pipeline().addLast("compressor", (ChannelHandler)new HttpContentCompressor());
        ch.pipeline().addLast("decoder", (ChannelHandler)new HttpResponseDecoder());
        ch.pipeline().addLast("encoder", (ChannelHandler)new HttpRequestEncoder());
        ch.pipeline().addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        this.handler = new TargetHandler();
        ch.pipeline().addLast("targetHandler", (ChannelHandler)this.handler);
    }

    public TargetHandler getTargetHandler() {
        return this.handler;
    }
}

