/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.examples.petstore.fileserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.annotation.Timed;
import org.wso2.msf4j.HttpStreamHandler;
import org.wso2.msf4j.HttpStreamer;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.analytics.httpmonitoring.HTTPMonitored;

@HTTPMonitored
@Path(value="/")
public class FileServerService {
    private static final Logger log = LoggerFactory.getLogger(FileServerService.class);
    private static final java.nio.file.Path MOUNT_PATH = Paths.get(File.separator + "var", "www", "html", "upload");

    @POST
    @Path(value="/{fileName}")
    @Timed
    public void postFile(@Context HttpStreamer httpStreamer, @PathParam(value="fileName") String fileName) throws IOException {
        log.info("Adding file: " + fileName);
        httpStreamer.callback(new HttpStreamHandlerImpl(fileName));
    }

    @GET
    @Path(value="/{fileName}")
    @Timed
    public javax.ws.rs.core.Response getFile(@PathParam(value="fileName") String fileName) {
        log.info("Retrieving file: " + fileName);
        File file = Paths.get(MOUNT_PATH.toString(), fileName).toFile();
        if (file.exists()) {
            return javax.ws.rs.core.Response.ok(file).build();
        }
        return javax.ws.rs.core.Response.status(Response.Status.NOT_FOUND).build();
    }

    private static class HttpStreamHandlerImpl
    implements HttpStreamHandler {
        private FileChannel fileChannel = null;
        private Response response;

        public HttpStreamHandlerImpl(String fileName) throws FileNotFoundException {
            File file = Paths.get(MOUNT_PATH.toString(), fileName).toFile();
            if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                this.fileChannel = new FileOutputStream(file).getChannel();
            }
        }

        @Override
        public void init(Response response) {
            this.response = response;
        }

        @Override
        public void end() throws Exception {
            this.fileChannel.close();
            this.response.setStatus(Response.Status.ACCEPTED.getStatusCode());
            this.response.send();
        }

        @Override
        public void chunk(ByteBuffer content) throws Exception {
            if (this.fileChannel == null) {
                throw new IOException("Unable to write file");
            }
            this.fileChannel.write(content);
        }

        @Override
        public void error(Throwable cause) {
            try {
                if (this.fileChannel != null) {
                    this.fileChannel.close();
                }
            }
            catch (IOException e) {
                log.error("Unable to close file output stream", e);
            }
        }
    }
}

