/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.commons.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class BinaryMessageConverterUtil {
    public static byte[] loadData(InputStream in, byte[] dataArray) throws IOException {
        int readCount;
        int start = 0;
        while ((readCount = in.read(dataArray, start, dataArray.length - start)) != -1) {
            if ((start += readCount) != dataArray.length) continue;
            return dataArray;
        }
        throw new EOFException("Connection closed from remote end.");
    }

    public static String getString(ByteBuffer byteBuffer, int size) {
        byte[] bytes = new byte[size];
        byteBuffer.get(bytes);
        return new String(bytes);
    }

    public static int getSize(Object data) {
        if (data instanceof String) {
            return 4 + ((String)data).length();
        }
        if (data instanceof Integer) {
            return 4;
        }
        if (data instanceof Long) {
            return 8;
        }
        if (data instanceof Float) {
            return 4;
        }
        if (data instanceof Double) {
            return 8;
        }
        if (data instanceof Boolean) {
            return 1;
        }
        return 4;
    }

    public static void assignData(Object data, ByteBuffer eventDataBuffer) throws IOException {
        if (data instanceof String) {
            eventDataBuffer.putInt(((String)data).length());
            eventDataBuffer.put(((String)data).getBytes("UTF-8"));
        } else if (data instanceof Integer) {
            eventDataBuffer.putInt((Integer)data);
        } else if (data instanceof Long) {
            eventDataBuffer.putLong((Long)data);
        } else if (data instanceof Float) {
            eventDataBuffer.putFloat(((Float)data).floatValue());
        } else if (data instanceof Double) {
            eventDataBuffer.putDouble((Double)data);
        } else if (data instanceof Boolean) {
            eventDataBuffer.put((byte)((Boolean)data != false ? 1 : 0));
        } else {
            eventDataBuffer.putInt(0);
        }
    }
}

