/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.netty.sender.channel;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.transport.http.netty.common.Util;

public class BootstrapConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(BootstrapConfiguration.class);
    private static BootstrapConfiguration bootstrapConfig;
    private boolean tcpNoDelay;
    private boolean keepAlive;
    private boolean socketReuse;
    private int connectTimeOut;
    private int receiveBufferSize;
    private int sendBufferSize;
    private int socketTimeout;

    private BootstrapConfiguration(Map<String, Object> properties) {
        this.connectTimeOut = Util.getIntProperty(properties, "client.bootstrap.connect.timeout", 15000);
        this.tcpNoDelay = Util.getBooleanProperty(properties, "client.bootstrap.nodelay", true);
        this.receiveBufferSize = Util.getIntProperty(properties, "client.bootstrap.recievebuffersize", 0x100000);
        this.sendBufferSize = Util.getIntProperty(properties, "client.bootstrap.sendbuffersize", 0x100000);
        this.socketTimeout = Util.getIntProperty(properties, "client.bootstrap.socket.timeout", 15);
        this.keepAlive = Util.getBooleanProperty(properties, "client.bootstrap.keepalive", true);
        this.socketReuse = Util.getBooleanProperty(properties, "client.bootstrap.socket.reuse", false);
        logger.debug("client.bootstrap.nodelay: " + this.tcpNoDelay);
        logger.debug("client.bootstrap.connect.timeout:" + this.connectTimeOut);
        logger.debug("client.bootstrap.recievebuffersize:" + this.receiveBufferSize);
        logger.debug("client.bootstrap.sendbuffersize:" + this.sendBufferSize);
        logger.debug("client.bootstrap.socket.timeout:" + this.socketTimeout);
        logger.debug("client.bootstrap.keepalive:" + this.keepAlive);
        logger.debug("client.bootstrap.socket.reuse:" + this.socketReuse);
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public static BootstrapConfiguration getInstance() {
        return bootstrapConfig;
    }

    public static void createBootStrapConfiguration(Map<String, Object> transportProperties) {
        bootstrapConfig = new BootstrapConfiguration(transportProperties);
    }
}

