/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl.reservoir;

import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.HistogramIterationValue;

public final class HdrHistogramSnapshot
extends Snapshot {
    private final Histogram histogram;

    public HdrHistogramSnapshot(Histogram histogram) {
        this.histogram = histogram;
    }

    @Override
    public double getValue(double quantile) {
        return this.histogram.getValueAtPercentile(quantile * 100.0);
    }

    @Override
    public long[] getValues() {
        long[] values = new long[(int)this.histogram.getTotalCount()];
        int i = 0;
        for (HistogramIterationValue value : this.histogram.recordedValues()) {
            long v = value.getValueIteratedTo();
            int j = 0;
            while ((long)j < value.getCountAddedInThisIterationStep()) {
                values[i] = v;
                ++i;
                ++j;
            }
        }
        return values;
    }

    @Override
    public int size() {
        return (int)this.histogram.getTotalCount();
    }

    @Override
    public long getMax() {
        return this.histogram.getMaxValue();
    }

    @Override
    public double getMean() {
        return this.histogram.getMean();
    }

    @Override
    public long getMin() {
        return this.histogram.getMinValue();
    }

    @Override
    public double getStdDev() {
        return this.histogram.getStdDeviation();
    }

    @Override
    public void dump(OutputStream output) {
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            for (HistogramIterationValue value : this.histogram.recordedValues()) {
                long v = value.getValueIteratedTo();
                int j = 0;
                while ((long)j < value.getCountAddedInThisIterationStep()) {
                    out.printf("%d%n", v);
                    ++j;
                }
            }
        }
    }
}

