/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.transport.http.netty.contractimpl.sender.websocket;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.websocket.ClientHandshakeFuture;
import org.wso2.transport.http.netty.contract.websocket.WebSocketClientConnectorConfig;
import org.wso2.transport.http.netty.contractimpl.common.Util;
import org.wso2.transport.http.netty.contractimpl.common.ssl.SSLConfig;
import org.wso2.transport.http.netty.contractimpl.listener.MessageQueueHandler;
import org.wso2.transport.http.netty.contractimpl.sender.websocket.WebSocketClientCompressionHandler;
import org.wso2.transport.http.netty.contractimpl.sender.websocket.WebSocketClientHandshakeHandler;
import org.wso2.transport.http.netty.contractimpl.websocket.DefaultClientHandshakeFuture;

public class WebSocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClient.class);
    private WebSocketClientHandshakeHandler clientHandshakeHandler;
    private final String url;
    private final String subProtocols;
    private final int idleTimeout;
    private final HttpHeaders headers;
    private final int maxFrameSize;
    private final EventLoopGroup wsClientEventLoopGroup;
    private final boolean autoRead;
    private final WebSocketClientConnectorConfig connectorConfig;

    public WebSocketClient(EventLoopGroup wsClientEventLoopGroup, WebSocketClientConnectorConfig connectorConfig) {
        this.url = connectorConfig.getRemoteAddress();
        this.subProtocols = connectorConfig.getSubProtocolsAsCSV();
        this.idleTimeout = connectorConfig.getIdleTimeoutInMillis();
        this.headers = connectorConfig.getHeaders();
        this.wsClientEventLoopGroup = wsClientEventLoopGroup;
        this.autoRead = connectorConfig.isAutoRead();
        this.maxFrameSize = connectorConfig.getMaxFrameSize();
        this.connectorConfig = connectorConfig;
    }

    public ClientHandshakeFuture handshake() {
        DefaultClientHandshakeFuture handshakeFuture = new DefaultClientHandshakeFuture();
        try {
            URI uri = new URI(this.url);
            String scheme = uri.getScheme();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                LOG.error("Only WS(S) is supported.");
                throw new URISyntaxException(this.url, "WebSocket client supports only WS(S) scheme");
            }
            String host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            int port = this.getPort(uri);
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            WebSocketClientHandshaker webSocketHandshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, WebSocketVersion.V13, this.subProtocols, true, this.headers, this.maxFrameSize);
            MessageQueueHandler messageQueueHandler = new MessageQueueHandler();
            this.clientHandshakeHandler = new WebSocketClientHandshakeHandler(webSocketHandshaker, handshakeFuture, messageQueueHandler, ssl, this.autoRead, this.url, handshakeFuture);
            Bootstrap clientBootstrap = this.initClientBootstrap(host, port, handshakeFuture);
            clientBootstrap.connect(uri.getHost(), port).sync();
        }
        catch (Exception throwable) {
            this.handleHandshakeError(handshakeFuture, throwable);
        }
        return handshakeFuture;
    }

    private void handleHandshakeError(DefaultClientHandshakeFuture handshakeFuture, Throwable throwable) {
        if (this.clientHandshakeHandler != null) {
            handshakeFuture.notifyError(throwable, this.clientHandshakeHandler.getHttpCarbonResponse());
        } else {
            handshakeFuture.notifyError(throwable, null);
        }
    }

    private Bootstrap initClientBootstrap(final String host, final int port, final DefaultClientHandshakeFuture handshakeFuture) {
        Bootstrap clientBootstrap = new Bootstrap();
        final SSLConfig sslConfig = this.connectorConfig.getClientSSLConfig();
        ((Bootstrap)((Bootstrap)clientBootstrap.group(this.wsClientEventLoopGroup)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel socketChannel) throws SSLException {
                if (sslConfig != null) {
                    SSLEngine sslEngine = Util.configureHttpPipelineForSSL(socketChannel, host, port, sslConfig);
                    socketChannel.pipeline().addLast("sslHandshakeCompletionHandler", (ChannelHandler)new WebSocketClientSSLHandshakeCompletionHandler(handshakeFuture, sslEngine));
                } else {
                    WebSocketClient.this.configureHandshakePipeline(socketChannel.pipeline());
                }
            }
        });
        return clientBootstrap;
    }

    private void configureHandshakePipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new HttpClientCodec());
        pipeline.addLast(new HttpObjectAggregator(8192));
        pipeline.addLast(WebSocketClientCompressionHandler.INSTANCE);
        pipeline.addLast(Utf8FrameValidator.class.getName(), (ChannelHandler)new Utf8FrameValidator());
        if (this.idleTimeout > 0) {
            pipeline.addLast(new IdleStateHandler(0L, 0L, this.idleTimeout, TimeUnit.MILLISECONDS));
        }
        pipeline.addLast("websocket-client-handshake-handler", (ChannelHandler)this.clientHandshakeHandler);
    }

    private int getPort(URI uri) {
        String scheme = uri.getScheme();
        if (uri.getPort() == -1) {
            switch (scheme) {
                case "ws": {
                    return 80;
                }
                case "wss": {
                    return 443;
                }
            }
            return -1;
        }
        return uri.getPort();
    }

    private class WebSocketClientSSLHandshakeCompletionHandler
    extends ChannelInboundHandlerAdapter {
        private final DefaultClientHandshakeFuture clientHandshakeFuture;
        private SSLEngine sslEngine;

        private WebSocketClientSSLHandshakeCompletionHandler(DefaultClientHandshakeFuture clientHandshakeFuture, SSLEngine sslEngine) {
            this.clientHandshakeFuture = clientHandshakeFuture;
            this.sslEngine = sslEngine;
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws CertificateNotYetValidException, CertificateExpiredException, SSLPeerUnverifiedException {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
                if (event.isSuccess() && event.cause() == null) {
                    try {
                        X509Certificate endUserCert = (X509Certificate)this.sslEngine.getSession().getPeerCertificates()[0];
                        endUserCert.checkValidity(new Date());
                    }
                    catch (CertificateExpiredException e) {
                        this.clientHandshakeFuture.notifyError(new SSLException("Certificate expired : " + e.getMessage()), null);
                    }
                    WebSocketClient.this.configureHandshakePipeline(ctx.channel().pipeline());
                    ctx.pipeline().remove("sslHandshakeCompletionHandler");
                    ctx.fireChannelActive();
                } else {
                    this.clientHandshakeFuture.notifyError(event.cause(), null);
                }
            }
        }
    }
}

