/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.conf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.wso2.carbon.databridge.agent.conf.Agent;
import org.wso2.carbon.databridge.agent.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.conf.DataAgentsConfiguration;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.commons.utils.DataBridgeCommonsUtils;

public class DataAgentConfigurationFileResolver {
    public static DataAgentsConfiguration resolveAndSetDataAgentConfiguration(LinkedHashMap dataAgentConfigurationHashMap) throws DataEndpointAgentConfigurationException {
        DataAgentsConfiguration dataAgentsConfiguration = new DataAgentsConfiguration();
        ArrayList<Agent> agents = new ArrayList<Agent>();
        dataAgentsConfiguration.setAgents(agents);
        ArrayList agentList = (ArrayList)dataAgentConfigurationHashMap.get("agents");
        if (agentList != null) {
            for (Object agentConfigurationWrapper : agentList) {
                String trustStorePath;
                Object trustStorePathObject;
                LinkedHashMap agentConfigurationHashMap = (LinkedHashMap)((LinkedHashMap)agentConfigurationWrapper).get("agentConfiguration");
                Agent agent = new Agent();
                AgentConfiguration agentConfiguration = agent.getAgentConfiguration();
                Object endpointNameConfig = agentConfigurationHashMap.get("name");
                if (endpointNameConfig == null || endpointNameConfig.toString().trim().isEmpty()) {
                    throw new DataEndpointAgentConfigurationException("Endpoint name is not set in data.agent.config.yaml");
                }
                agentConfiguration.setName(endpointNameConfig.toString().trim());
                Object endpointClassConfig = agentConfigurationHashMap.get("dataEndpointClass");
                if (endpointClassConfig == null || endpointClassConfig.toString().trim().isEmpty()) {
                    throw new DataEndpointAgentConfigurationException("Endpoint class name is not set in data.agent.config.yaml for name: " + endpointNameConfig);
                }
                agentConfiguration.setDataEndpointClass(endpointClassConfig.toString().trim());
                if (agentConfigurationHashMap.get("publishingStrategy") != null) {
                    agentConfiguration.setPublishingStrategy(agentConfigurationHashMap.get("publishingStrategy").toString().trim());
                }
                if ((trustStorePathObject = agentConfigurationHashMap.get("trustStorePath")) != null && !(trustStorePath = trustStorePathObject.toString().trim()).isEmpty()) {
                    agentConfiguration.setTrustStorePath(DataBridgeCommonsUtils.replaceSystemProperty(trustStorePath));
                }
                if (agentConfigurationHashMap.get("trustStorePassword") != null) {
                    agentConfiguration.setTrustStorePassword(agentConfigurationHashMap.get("trustStorePassword").toString().trim());
                }
                if (agentConfigurationHashMap.get("queueSize") != null) {
                    agentConfiguration.setQueueSize(Integer.parseInt(agentConfigurationHashMap.get("queueSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("batchSize") != null) {
                    agentConfiguration.setBatchSize(Integer.parseInt(agentConfigurationHashMap.get("batchSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("corePoolSize") != null) {
                    agentConfiguration.setCorePoolSize(Integer.parseInt(agentConfigurationHashMap.get("corePoolSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("socketTimeoutMS") != null) {
                    agentConfiguration.setSocketTimeoutMS(Integer.parseInt(agentConfigurationHashMap.get("socketTimeoutMS").toString().trim()));
                }
                if (agentConfigurationHashMap.get("maxPoolSize") != null) {
                    agentConfiguration.setMaxPoolSize(Integer.parseInt(agentConfigurationHashMap.get("maxPoolSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("keepAliveTimeInPool") != null) {
                    agentConfiguration.setKeepAliveTimeInPool(Integer.parseInt(agentConfigurationHashMap.get("keepAliveTimeInPool").toString().trim()));
                }
                if (agentConfigurationHashMap.get("reconnectionInterval") != null) {
                    agentConfiguration.setReconnectionInterval(Integer.parseInt(agentConfigurationHashMap.get("reconnectionInterval").toString().trim()));
                }
                if (agentConfigurationHashMap.get("maxTransportPoolSize") != null) {
                    agentConfiguration.setMaxTransportPoolSize(Integer.parseInt(agentConfigurationHashMap.get("maxTransportPoolSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("maxIdleConnections") != null) {
                    agentConfiguration.setMaxIdleConnections(Integer.parseInt(agentConfigurationHashMap.get("maxIdleConnections").toString().trim()));
                }
                if (agentConfigurationHashMap.get("evictionTimePeriod") != null) {
                    agentConfiguration.setEvictionTimePeriod(Integer.parseInt(agentConfigurationHashMap.get("evictionTimePeriod").toString().trim()));
                }
                if (agentConfigurationHashMap.get("minIdleTimeInPool") != null) {
                    agentConfiguration.setMinIdleTimeInPool(Integer.parseInt(agentConfigurationHashMap.get("minIdleTimeInPool").toString().trim()));
                }
                if (agentConfigurationHashMap.get("secureMaxTransportPoolSize") != null) {
                    agentConfiguration.setSecureMaxTransportPoolSize(Integer.parseInt(agentConfigurationHashMap.get("secureMaxTransportPoolSize").toString().trim()));
                }
                if (agentConfigurationHashMap.get("secureMaxIdleConnections") != null) {
                    agentConfiguration.setSecureMaxIdleConnections(Integer.parseInt(agentConfigurationHashMap.get("secureMaxIdleConnections").toString().trim()));
                }
                if (agentConfigurationHashMap.get("secureEvictionTimePeriod") != null) {
                    agentConfiguration.setSecureEvictionTimePeriod(Integer.parseInt(agentConfigurationHashMap.get("secureEvictionTimePeriod").toString().trim()));
                }
                if (agentConfigurationHashMap.get("secureMinIdleTimeInPool") != null) {
                    agentConfiguration.setSecureMinIdleTimeInPool(Integer.parseInt(agentConfigurationHashMap.get("secureMinIdleTimeInPool").toString().trim()));
                }
                if (agentConfigurationHashMap.get("sslEnabledProtocols") != null) {
                    agentConfiguration.setSslEnabledProtocols(agentConfigurationHashMap.get("sslEnabledProtocols").toString().trim());
                }
                if (agentConfigurationHashMap.get("ciphers") != null) {
                    agentConfiguration.setCiphers(agentConfigurationHashMap.get("ciphers").toString().trim());
                }
                agents.add(agent);
            }
        } else {
            throw new DataEndpointAgentConfigurationException("Data Agents are not defined in data.agent.config.yaml");
        }
        return dataAgentsConfiguration;
    }
}

