/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.config.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.secvault.SecureVault;
import org.wso2.carbon.utils.Utils;

@Component(name="ConfigProviderComponent", immediate=true)
public class ConfigProviderComponent {
    private static final Logger logger = LoggerFactory.getLogger(ConfigProviderComponent.class);
    private SecureVault secureVault = null;

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.initializeConfigProvider(bundleContext);
        logger.debug("Carbon Configuration Component activated");
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        logger.debug("Stopping ConfigProviderComponent");
    }

    @Reference(name="org.wso2.carbon.secvault.SecureVault", service=SecureVault.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unRegisterSecureVault")
    protected void registerSecureVault(SecureVault secureVault) {
        this.secureVault = secureVault;
    }

    protected void unRegisterSecureVault(SecureVault secureVault) {
        this.secureVault = null;
    }

    private void initializeConfigProvider(BundleContext bundleContext) {
        try {
            Path deploymentConfigPath = Paths.get(Utils.getRuntimeConfigPath().toString(), "deployment.yaml");
            ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider(deploymentConfigPath, this.secureVault);
            bundleContext.registerService(ConfigProvider.class, configProvider, null);
            logger.debug("ConfigProvider OSGi service registered successfully");
        }
        catch (ConfigurationException e) {
            logger.error("Error occurred while initializing config provider", e);
        }
    }
}

