/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.msf4j.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Date;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.Response;
import org.wso2.msf4j.interceptor.RequestInterceptor;
import org.wso2.msf4j.util.SystemVariableUtil;

public class JWTSecurityInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JWTSecurityInterceptor.class);
    private static final String JWT_HEADER = "X-JWT-Assertion";
    private static final String AUTH_TYPE_JWT = "JWT";
    private static final String KEYSTORE = SystemVariableUtil.getValue("PETSTORE_KEYSTORE", "wso2carbon.jks");
    private static final String ALIAS = SystemVariableUtil.getValue("PETSTORE_KEY_ALIAS", "wso2carbon");
    private static final String KEYSTORE_PASSWORD = SystemVariableUtil.getValue("PETSTORE_KEYSTORE_PASS", "wso2carbon");

    @Override
    public boolean interceptRequest(Request request, Response response) throws Exception {
        boolean isValidSignature;
        log.info("Authentication precall");
        String jwtHeader = request.getHeader(JWT_HEADER);
        if (jwtHeader != null && (isValidSignature = this.verifySignature(jwtHeader))) {
            return true;
        }
        response.setHeader("WWW-Authenticate", AUTH_TYPE_JWT);
        response.setStatus(Response.Status.UNAUTHORIZED.getStatusCode());
        return false;
    }

    private boolean verifySignature(String jwt) {
        try {
            SignedJWT signedJWT = SignedJWT.parse(jwt);
            if (new Date().before(signedJWT.getJWTClaimsSet().getExpirationTime())) {
                RSASSAVerifier verifier = new RSASSAVerifier((RSAPublicKey)this.getPublicKey(KEYSTORE, KEYSTORE_PASSWORD, ALIAS));
                return signedJWT.verify(verifier);
            }
            log.info("Token has expired");
        }
        catch (JOSEException | IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | ParseException e) {
            log.error("Error occurred while JWT signature verification. JWT=" + jwt, e);
        }
        return false;
    }

    private PublicKey getPublicKey(String keyStorePath, String keyStorePassword, String alias) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(keyStorePath);){
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(inputStream, keyStorePassword.toCharArray());
            Key key = keystore.getKey(alias, keyStorePassword.toCharArray());
            if (key instanceof PrivateKey) {
                Certificate cert = keystore.getCertificate(alias);
                PublicKey publicKey = cert.getPublicKey();
                return publicKey;
            }
        }
        return null;
    }
}

