/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.kernel.internal;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.kernel.CarbonRuntime;
import org.wso2.carbon.kernel.internal.DataHolder;
import org.wso2.carbon.kernel.internal.config.YAMLBasedConfigProvider;
import org.wso2.carbon.kernel.internal.context.CarbonRuntimeFactory;
import org.wso2.carbon.kernel.internal.logging.LoggingConfiguration;

public class CarbonCoreBundleActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(CarbonCoreBundleActivator.class);
    private LoggingConfiguration loggingConfiguration = LoggingConfiguration.getInstance();
    private ManagedService configAdminService;

    public void start(BundleContext bundleContext) throws Exception {
        DataHolder.getInstance().setBundleContext(bundleContext);
        ServiceReference reference = bundleContext.getServiceReference(ManagedService.class);
        if (reference == null) {
            throw new IllegalStateException("Cannot start carbon core bundle since configuration admin service is not available");
        }
        this.configAdminService = (ManagedService)bundleContext.getService(reference);
        this.loggingConfiguration.register(this.configAdminService);
        YAMLBasedConfigProvider configProvider = new YAMLBasedConfigProvider();
        CarbonRuntime carbonRuntime = CarbonRuntimeFactory.createCarbonRuntime(configProvider);
        bundleContext.registerService(CarbonRuntime.class.getName(), (Object)carbonRuntime, null);
        DataHolder.getInstance().setCarbonRuntime(carbonRuntime);
        logger.debug("Carbon core bundle is started successfully");
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.configAdminService != null) {
            this.loggingConfiguration.unregister(this.configAdminService);
        }
        logger.debug("Carbon core bundle is stopped successfully");
    }
}

